/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.Utils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public abstract class CopySupport {
    private static boolean showMessage = true;

    static CopySupport getInstance() {
        return new CopyImpl();
    }

    abstract void projectOpened(PhpProject var1);

    abstract void projectClosed(PhpProject var1);

    public abstract void waitFinished();

    private static void showProblem(Exception exception) {
        if (showMessage) {
            String string = NbBundle.getMessage(CopySupport.class, (String)"LBL_CopyFilesError", (Object)exception.getLocalizedMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)exception, (Object)string));
            showMessage = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceTargetPair<S, T> {
        private final S source;
        private final T target;
        private final Modifier modifier;

        static SourceTargetPair<FileObject, FileObject> forInvalidConfig() {
            return new SourceTargetPair<FileObject, FileObject>();
        }

        static SourceTargetPair<FileObject, File> forInit(SourceTargetPair<FileObject, FileObject> sourceTargetPair) {
            FileObject fileObject = sourceTargetPair.getSource();
            File file = FileUtil.toFile((FileObject)sourceTargetPair.getTarget());
            assert (fileObject.isFolder());
            assert (file.isDirectory());
            return new SourceTargetPair<FileObject, File>(fileObject, file, Modifier.INIT);
        }

        static SourceTargetPair<FileObject, FileObject> forConfig(FileObject fileObject, FileObject fileObject2, boolean bl) {
            assert (fileObject.isFolder());
            assert (fileObject2.isFolder());
            return new SourceTargetPair<FileObject, FileObject>(fileObject, fileObject2, bl ? Modifier.COPY : Modifier.IDLE);
        }

        static SourceTargetPair<FileObject, File> forDelete(FileObject fileObject, File file) {
            return new SourceTargetPair<FileObject, File>(fileObject, file, Modifier.DELETE);
        }

        static SourceTargetPair<FileObject, File> forCopy(FileObject fileObject, File file) {
            return new SourceTargetPair<FileObject, File>(fileObject, file, Modifier.COPY);
        }

        private SourceTargetPair() {
            this.modifier = Modifier.INVALID;
            this.source = null;
            this.target = null;
        }

        private SourceTargetPair(S s, T t, Modifier modifier) {
            this.modifier = modifier;
            assert (s != null);
            assert (t != null);
            this.source = s;
            this.target = t;
        }

        S getSource() {
            assert (this.isInvalidModifier() || this.source != null);
            return this.source;
        }

        T getTarget() {
            assert (this.isInvalidModifier() || this.target != null);
            return this.target;
        }

        boolean isIdleModifier() {
            return this.modifier.equals((Object)Modifier.IDLE);
        }

        boolean isCopyModifier() {
            return this.modifier.equals((Object)Modifier.COPY);
        }

        boolean isDeleteModifier() {
            return this.modifier.equals((Object)Modifier.DELETE);
        }

        boolean isInvalidModifier() {
            return this.modifier.equals((Object)Modifier.INVALID);
        }

        boolean isInitModifier() {
            return this.modifier.equals((Object)Modifier.INIT);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Modifier {
            IDLE,
            COPY,
            DELETE,
            INIT,
            INVALID;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationFactory {
        private final PhpProject project;
        private final SourceTargetPair<FileObject, FileObject> config;
        private final AntProjectHelper antProjectHelper;

        ConfigurationFactory(PhpProject phpProject) {
            FileObject fileObject;
            assert (phpProject != null);
            this.project = phpProject;
            boolean bl = this.isCopyEnabled();
            FileObject fileObject2 = this.getSourceRoot();
            FileObject fileObject3 = fileObject = this.isCopyEnabled() ? this.getTargetRoot(true) : this.getTargetRoot(false);
            if (fileObject2 != null && fileObject != null && fileObject2 != fileObject && fileObject.canWrite()) {
                showMessage = true;
                this.config = SourceTargetPair.forConfig(fileObject2, fileObject, bl);
            } else {
                if (showMessage && bl && fileObject2 != null && fileObject != null) {
                    CopySupport.showProblem(new Exception(""));
                }
                this.config = CopyImpl.INVALID_CONFIG;
            }
            this.antProjectHelper = phpProject.getHelper();
            assert (this.antProjectHelper != null);
        }

        SourceTargetPair<FileObject, FileObject> getConfiguration() {
            assert (this.config != null);
            return this.config;
        }

        boolean isCopyEnabled() {
            boolean bl = false;
            String string = this.project.getEvaluator().getProperty("copy.src.files");
            if (string != null && string.trim().length() > 0) {
                bl = Boolean.parseBoolean(string);
            }
            return bl;
        }

        private FileObject getSourceRoot() {
            FileObject fileObject = null;
            FileObject[] fileObjectArray = Utils.getSourceObjects(this.project);
            if (fileObjectArray != null && fileObjectArray.length > 0) {
                fileObject = fileObjectArray[0];
                assert (FileUtil.toFile((FileObject)fileObject) != null) : fileObject.toString();
                assert (fileObject.isFolder()) : fileObject.getPath();
            }
            return fileObject;
        }

        private FileObject getTargetRoot(boolean bl) {
            FileObject fileObject = null;
            String string = this.project.getEvaluator().getProperty("copy.src.target");
            if (string != null && string.trim().length() > 0) {
                File file = FileUtil.normalizeFile((File)new File(string));
                if (bl) {
                    try {
                        fileObject = FileUtil.createFolder((File)file);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                } else {
                    fileObject = FileUtil.toFileObject((File)file);
                }
            }
            return fileObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CopyImpl
    extends CopySupport
    implements PropertyChangeListener,
    FileChangeListener {
        private static final SourceTargetPair<FileObject, FileObject> INVALID_CONFIG = SourceTargetPair.forInvalidConfig();
        private static final RequestProcessor RP = new RequestProcessor("PHP replication");
        private volatile PhpProject project;
        private SourceTargetPair<FileObject, FileObject> config;
        private FileSystem fileSystem;
        private FileChangeListener weakFileChangeListener;
        private boolean isProjectOpened;
        private static final Queue<SourceTargetPair<FileObject, File>> allPairs = new ConcurrentLinkedQueue<SourceTargetPair<FileObject, File>>();
        private static final RequestProcessor.Task task = RP.create(new Runnable(){

            @Override
            public void run() {
                SourceTargetPair sourceTargetPair = (SourceTargetPair)allPairs.poll();
                HashMap hashMap = new HashMap();
                while (sourceTargetPair != null) {
                    if (sourceTargetPair.isInitModifier()) {
                        this.doInit(sourceTargetPair);
                    } else {
                        hashMap.put(sourceTargetPair.getTarget(), sourceTargetPair);
                    }
                    sourceTargetPair = (SourceTargetPair)allPairs.poll();
                }
                for (SourceTargetPair sourceTargetPair2 : hashMap.values()) {
                    if (sourceTargetPair2.isCopyModifier()) {
                        this.doCopy(sourceTargetPair2);
                        continue;
                    }
                    if (sourceTargetPair2.isDeleteModifier()) {
                        this.doDelete(sourceTargetPair2);
                        continue;
                    }
                    assert (false);
                }
            }

            private void doInit(SourceTargetPair<FileObject, File> sourceTargetPair) {
                try {
                    File[] fileArray;
                    File file = sourceTargetPair.getTarget();
                    for (File file2 : fileArray = file.listFiles()) {
                        this.doDelete(file2);
                    }
                }
                catch (IOException iOException) {
                    CopySupport.showProblem(iOException);
                }
            }

            private void doCopy(SourceTargetPair<FileObject, File> sourceTargetPair) {
                try {
                    File file = sourceTargetPair.getTarget();
                    File file2 = file.getParentFile();
                    FileObject fileObject = sourceTargetPair.getSource();
                    if (fileObject.isData()) {
                        this.doDelete(file);
                        FileObject fileObject2 = FileUtil.createFolder((File)file2);
                        FileUtil.copyFile((FileObject)sourceTargetPair.getSource(), (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
                    } else {
                        String[] stringArray = file.list();
                        if (stringArray == null || stringArray.length == 0) {
                            this.doDelete(file);
                        }
                        FileUtil.createFolder((File)file);
                    }
                }
                catch (IOException iOException) {
                    CopySupport.showProblem(iOException);
                }
            }

            private void doDelete(SourceTargetPair<FileObject, File> sourceTargetPair) {
                try {
                    this.doDelete(sourceTargetPair.getTarget());
                }
                catch (IOException iOException) {
                    CopySupport.showProblem(iOException);
                }
            }

            private void doDelete(File file) throws IOException {
                if (file.exists()) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject != null && fileObject.isValid()) {
                        fileObject.delete();
                    } else {
                        file.delete();
                    }
                }
            }
        });

        private CopyImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("copy.src.target") || string.equals("src.dir") || string.equals("copy.src.files")) {
                ProjectManager.mutex().readAccess(new Runnable(){

                    public void run() {
                        CopyImpl.this.setConfig(new ConfigurationFactory(CopyImpl.this.project).getConfiguration());
                        CopyImpl.this.start(true);
                    }
                });
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.prepareForCopy(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.prepareForCopy(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.prepareForCopy(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.prepareForDelete(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.prepareForRename(fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        @Override
        protected void projectOpened(PhpProject phpProject) {
            this.init(phpProject);
            this.isProjectOpened = true;
            this.start(false);
        }

        @Override
        protected void projectClosed(PhpProject phpProject) {
            this.isProjectOpened = false;
            this.stop();
        }

        PhpProject getProject() {
            return this.project;
        }

        synchronized SourceTargetPair<FileObject, FileObject> getConfig() {
            return this.config != null ? this.config : INVALID_CONFIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setConfig(SourceTargetPair<FileObject, FileObject> sourceTargetPair) {
            assert (sourceTargetPair != null);
            CopyImpl copyImpl = this;
            synchronized (copyImpl) {
                this.config = sourceTargetPair;
            }
        }

        private boolean isProjectFolder(FileObject fileObject) {
            return FileUtil.isParentOf((FileObject)this.getConfig().getSource(), (FileObject)fileObject);
        }

        private FileObject getSourceRoot() {
            return this.getConfig().getSource();
        }

        private FileObject getTargetRoot() {
            return this.getConfig().getTarget();
        }

        private void init(PhpProject phpProject) {
            if (this.project == null) {
                this.project = phpProject;
                PropertyEvaluator propertyEvaluator = phpProject.getEvaluator();
                propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
                ConfigurationFactory configurationFactory = new ConfigurationFactory(phpProject);
                this.setConfig(configurationFactory.getConfiguration());
            } else assert (this.project.equals(phpProject));
        }

        private boolean isCopyAllowed(FileObject fileObject, boolean bl) {
            if (this.getConfig().isInvalidModifier() || !this.isProjectFolder(fileObject)) {
                return false;
            }
            if (!bl) {
                File file = FileUtil.toFile((FileObject)this.getConfig().getSource());
                for (File file2 = FileUtil.toFile((FileObject)fileObject); file2 != null && !file2.equals(file); file2 = file2.getParentFile()) {
                    if (VisibilityQuery.getDefault().isVisible(file2)) continue;
                    return false;
                }
            }
            return true;
        }

        private void prepareForCopy(FileObject fileObject) {
            if (this.isCopyAllowed(fileObject, false)) {
                assert (fileObject.isValid());
                this.prepareOperation(fileObject, false);
            }
        }

        private void prepareForCopy(FileEvent fileEvent) {
            SourceTargetPair<FileObject, FileObject> sourceTargetPair = this.getConfig();
            if (sourceTargetPair != null && !sourceTargetPair.isInvalidModifier() && sourceTargetPair.isCopyModifier()) {
                FileObject fileObject = fileEvent.getFile();
                this.prepareForCopy(fileObject);
            }
        }

        private void prepareForDelete(FileEvent fileEvent) {
            SourceTargetPair<FileObject, FileObject> sourceTargetPair = this.getConfig();
            if (sourceTargetPair != null && !sourceTargetPair.isInvalidModifier() && sourceTargetPair.isCopyModifier()) {
                FileObject fileObject = fileEvent.getFile();
                this.prepareForDelete(fileObject);
            }
        }

        private void prepareForDelete(FileObject fileObject) {
            if (this.isCopyAllowed(fileObject, true)) {
                assert (!fileObject.isValid());
                this.prepareOperation(fileObject, true);
            }
        }

        private void prepareForRename(FileRenameEvent fileRenameEvent) {
            FileObject fileObject;
            SourceTargetPair<FileObject, FileObject> sourceTargetPair = this.getConfig();
            if (sourceTargetPair != null && !sourceTargetPair.isInvalidModifier() && sourceTargetPair.isCopyModifier() && this.isCopyAllowed(fileObject = fileRenameEvent.getFile(), false)) {
                Object object;
                if (fileObject.isFolder()) {
                    for (Object object2 : object = fileObject.getChildren()) {
                        this.prepareForCopy((FileObject)object2);
                    }
                } else {
                    this.prepareForCopy(fileObject);
                }
                object = this.targetForSource(fileObject);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(fileRenameEvent.getName());
                String string = fileRenameEvent.getExt();
                if (string != null && string.trim().length() > 0) {
                    stringBuilder.append('.').append(string);
                }
                File file = new File(((File)object).getParent(), stringBuilder.toString());
                this.prepareOperation(SourceTargetPair.forDelete(fileObject, file));
            }
        }

        private synchronized void prepareInitCopy() {
            FileObject fileObject = this.getTargetRoot();
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                String[] stringArray = file.list();
                Enumeration enumeration = this.getSourceRoot().getChildren(true);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    this.prepareForCopy(fileObject2);
                }
            }
        }

        private boolean existsEmptyFolder(FileObject fileObject) {
            assert (fileObject != null);
            assert (fileObject.isFolder());
            return this.existsEmptyFolder(FileUtil.toFile((FileObject)fileObject));
        }

        private boolean existsEmptyFolder(File file) {
            assert (file.isDirectory());
            String[] stringArray = file.list();
            return stringArray != null && stringArray.length == 0;
        }

        private void prepareOperation(FileObject fileObject, boolean bl) {
            File file = this.targetForSource(fileObject);
            if (bl) {
                this.prepareOperation(SourceTargetPair.forDelete(fileObject, file));
            } else {
                this.prepareOperation(SourceTargetPair.forCopy(fileObject, file));
            }
            task.schedule(300);
        }

        private void prepareOperation(SourceTargetPair<FileObject, File> sourceTargetPair) {
            allPairs.offer(sourceTargetPair);
            task.schedule(300);
        }

        private synchronized void start(boolean bl) {
            this.stop();
            SourceTargetPair<FileObject, FileObject> sourceTargetPair = this.getConfig();
            if (sourceTargetPair != null && !sourceTargetPair.isInvalidModifier() && sourceTargetPair.isCopyModifier()) {
                if (bl || this.existsEmptyFolder(sourceTargetPair.getTarget())) {
                    this.prepareInitCopy();
                }
                if (this.weakFileChangeListener == null && this.isProjectOpened) {
                    try {
                        this.fileSystem = sourceTargetPair.getSource().getFileSystem();
                        this.weakFileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.fileSystem);
                        this.fileSystem.addFileChangeListener(this.weakFileChangeListener);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                    }
                }
            }
        }

        private synchronized void stop() {
            if (this.weakFileChangeListener != null) {
                this.fileSystem.removeFileChangeListener(this.weakFileChangeListener);
                this.fileSystem = null;
                this.weakFileChangeListener = null;
            }
        }

        private String relativePathForSource(FileObject fileObject) {
            FileObject fileObject2 = this.getSourceRoot();
            assert (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject));
            return FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        }

        private File targetForSource(FileObject fileObject) {
            String string = this.relativePathForSource(fileObject);
            File file = FileUtil.toFile((FileObject)this.getConfig().getTarget());
            assert (file != null);
            File file2 = new File(file, string);
            return file2;
        }

        @Override
        public void waitFinished() {
            task.schedule(0);
            task.waitFinished();
        }
    }
}

