/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigManager {
    private static final String PROP_DISPLAY_NAME = "$label";
    private final Map<String, Map<String, String>> configs;
    private final Map<String, String> configErrors = new HashMap<String, String>();
    private final ConfigProvider configProvider;
    private final String[] propertyNames;
    private final ChangeSupport changeSupport;

    public ConfigManager(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.changeSupport = new ChangeSupport((Object)this);
        this.configs = configProvider.getConfigs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(configProvider.getConfigProperties()));
        arrayList.add(PROP_DISPLAY_NAME);
        this.propertyNames = arrayList.toArray(new String[arrayList.size()]);
    }

    public static Map<String, Map<String, String>> createEmptyConfigs() {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string != null ? (string2 != null ? string.compareTo(string2) : 1) : (string2 != null ? -1 : 0);
            }
        });
        treeMap.put(null, null);
        return treeMap;
    }

    public static Comparator<Configuration> getConfigurationComparator() {
        return new Comparator<Configuration>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(Configuration configuration, Configuration configuration2) {
                String string = configuration.getDisplayName();
                String string2 = configuration2.getDisplayName();
                return this.coll.compare(string, string2);
            }
        };
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public synchronized boolean exists(String string) {
        return this.configs.keySet().contains(string) && this.configs.get(string) != null;
    }

    public synchronized Configuration createNew(String string, String string2) {
        assert (!this.exists(string));
        this.configs.put(string, new HashMap());
        Configuration configuration = new Configuration(string);
        if (!string.equals(string2)) {
            configuration.putValue(PROP_DISPLAY_NAME, string2);
        }
        this.markAsCurrentConfiguration(string);
        return configuration;
    }

    public synchronized Collection<String> configurationNames() {
        return this.configs.keySet();
    }

    public synchronized Configuration currentConfiguration() {
        return new Configuration(this.configProvider.getActiveConfig());
    }

    public Configuration defaultConfiguration() {
        return new Configuration();
    }

    public synchronized Configuration configurationFor(String string) {
        return new Configuration(string);
    }

    public synchronized void markAsCurrentConfiguration(String string) {
        assert (this.configs.keySet().contains(string));
        this.configProvider.setActiveConfig(string);
        this.changeSupport.fireChange();
    }

    private String[] getPropertyNames() {
        return this.propertyNames;
    }

    private Map<String, String> getProperties(String string) {
        return this.configs.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConfigProvider {
        public String[] getConfigProperties();

        public Map<String, Map<String, String>> getConfigs();

        public String getActiveConfig();

        public void setActiveConfig(String var1);
    }

    public final class Configuration {
        private final String name;

        private Configuration() {
            this((String)null);
        }

        private Configuration(String string) {
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            assert (ConfigManager.this.configs.keySet().contains(string)) : "Unknown configuration: " + string;
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            String string = this.getValue(ConfigManager.PROP_DISPLAY_NAME);
            string = string != null ? string : this.getName();
            return string != null ? string : NbBundle.getMessage(ConfigManager.class, (String)"LBL_DefaultConfiguration");
        }

        public boolean isDefault() {
            return this.name == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                ConfigManager.this.configs.put(this.getName(), null);
                ConfigManager.this.configErrors.put(this.getName(), null);
                ConfigManager.this.markAsCurrentConfiguration(null);
            }
        }

        private boolean isDeleted() {
            return ConfigManager.this.configs.get(this.getName()) == null;
        }

        public String getValue(String string, boolean bl) {
            String string2 = this.getValue(string);
            if (bl && string2 != null) {
                string2 = this.rot13coder(string2);
            }
            return string2;
        }

        private String rot13coder(String string) {
            char[] cArray = new char[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= 'a' && c <= 'm') {
                    c = (char)(c + 13);
                } else if (c >= 'n' && c <= 'z') {
                    c = (char)(c - 13);
                } else if (c >= 'A' && c <= 'M') {
                    c = (char)(c + 13);
                } else if (c >= 'A' && c <= 'Z') {
                    c = (char)(c - 13);
                }
                cArray[i] = c;
            }
            return String.valueOf(cArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getValue(String string) {
            assert (Arrays.asList(this.getPropertyNames()).contains(string)) : "Unknown property: " + string;
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                return !this.isDeleted() ? (String)ConfigManager.this.getProperties(this.getName()).get(string) : null;
            }
        }

        public void putValue(String string, String string2, boolean bl) {
            if (bl && string2 != null) {
                string2 = this.rot13coder(string2);
            }
            this.putValue(string, string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putValue(String string, String string2) {
            assert (Arrays.asList(this.getPropertyNames()).contains(string)) : "Unknown property: " + string;
            assert (!this.isDeleted());
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                ConfigManager.this.getProperties(this.getName()).put(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getPropertyNames() {
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                return ConfigManager.this.getPropertyNames();
            }
        }

        public String getErrorMessage() {
            return (String)ConfigManager.this.configErrors.get(this.name);
        }

        public void setErrorMessage(String string) {
            ConfigManager.this.configErrors.put(this.name, string);
        }

        public boolean isValid() {
            return ConfigManager.this.configErrors.get(this.name) == null;
        }
    }
}

