/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableModel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class SortColumnHeaderRenderer
implements TableCellRenderer {
    private TransferFileTableModel model;
    private TableCellRenderer textRenderer;
    private String sortColumn;
    private ImageIcon sortDescIcon;
    private static ImageIcon sortAscIcon;
    private boolean sortAscending;

    public SortColumnHeaderRenderer(TransferFileTableModel transferFileTableModel, TableCellRenderer tableCellRenderer) {
        this.model = transferFileTableModel;
        this.textRenderer = tableCellRenderer;
        this.sortColumn = SortColumnHeaderRenderer.getPreferences().get("SortingColumn", this.getDefaultColumnSelected());
        this.sortAscending = SortColumnHeaderRenderer.getPreferences().getBoolean("SortAscending", true);
        this.model.sort(this.sortColumn, this.sortAscending);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.textRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            if (jTable.getColumnModel().getColumn(n2).getIdentifier().equals(this.sortColumn)) {
                jLabel.setIcon(this.sortAscending ? this.getSortAscIcon() : this.getSortDescIcon());
                jLabel.setHorizontalTextPosition(2);
            } else {
                jLabel.setIcon(null);
            }
        }
        return component;
    }

    public void setDefaultSorting() {
        this.setSorting(this.getDefaultColumnSelected());
    }

    private String getDefaultColumnSelected() {
        String string = null;
        string = this.model.getColumnName(1);
        return string;
    }

    public void setSorting(Object object) {
        if (!object.equals(this.sortColumn)) {
            this.sortColumn = (String)object;
            this.sortAscending = true;
        } else {
            this.sortAscending = !this.sortAscending;
        }
        SortColumnHeaderRenderer.getPreferences().put("SortingColumn", this.sortColumn);
        SortColumnHeaderRenderer.getPreferences().putBoolean("SortAscending", this.sortAscending);
        this.model.sort(object, this.sortAscending);
    }

    private ImageIcon getSortAscIcon() {
        if (sortAscIcon == null) {
            sortAscIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/columnsSortedDesc.gif"));
        }
        return sortAscIcon;
    }

    private ImageIcon getSortDescIcon() {
        if (this.sortDescIcon == null) {
            this.sortDescIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/columnsSortedAsc.gif"));
        }
        return this.sortDescIcon;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(SortColumnHeaderRenderer.class);
    }
}

