/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.environment.SolarisPhpEnvironment;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WindowsPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php.exe";
    private static final String XAMPP = "xampp";
    private static final FilenameFilter XAMPP_FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.toLowerCase().startsWith(WindowsPhpEnvironment.XAMPP);
        }
    };

    WindowsPhpEnvironment() {
    }

    @Override
    public List<PhpEnvironment.DocumentRoot> getDocumentRoots(String string) {
        File[] fileArray = File.listRoots();
        if (fileArray == null) {
            return Collections.emptyList();
        }
        File file = null;
        for (File file2 : fileArray) {
            File file3;
            if (!WindowsPhpEnvironment.isFloppy(file2) && ((file = WindowsPhpEnvironment.findHtDocsDirectory(file3 = new File(file2, "Program Files"), APACHE_FILENAME_FILTER)) != null || (file = new File(new File(file2, XAMPP), "htdocs")).isDirectory() || (file = WindowsPhpEnvironment.findHtDocsDirectory(file3, XAMPP_FILENAME_FILTER)) != null)) break;
        }
        if (file != null) {
            String string2 = WindowsPhpEnvironment.getFolderName(file, string);
            String string3 = WindowsPhpEnvironment.getDefaultUrl(string);
            String string4 = NbBundle.getMessage(SolarisPhpEnvironment.class, (String)"TXT_HtDocs");
            return Arrays.asList(new PhpEnvironment.DocumentRoot(string2, string3, string4, file.canWrite()));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        return WindowsPhpEnvironment.getAllPhpInterpreters(PHP);
    }

    private static boolean isFloppy(File file) {
        return file.getName().toLowerCase().startsWith("a:") || file.getName().toLowerCase().startsWith("b:");
    }
}

