/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.AbstractList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.ui.BrowseFolders;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Utils {
    public static final String URL_REGEXP = "^https?://([^/?#: ]+(:[^/?#: ]+)?@)?[^/?#: ]+(:\\d+)?/[^?# ]*(\\?[^#]*)?(#\\w*)?$";
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://([^/?#: ]+(:[^/?#: ]+)?@)?[^/?#: ]+(:\\d+)?/[^?# ]*(\\?[^#]*)?(#\\w*)?$");
    private static final char[] INVALID_FILENAME_CHARS = new char[]{'/', '\\', '|', ':', '*', '?', '\"', '<', '>'};

    private Utils() {
    }

    public static boolean isValidUrl(String string) {
        return URL_PATTERN.matcher(string).matches();
    }

    public static File browseLocationAction(Component component, File file, String string) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(1);
        if (file != null && file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(component)) {
            return FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
        }
        return null;
    }

    public static File browseLocalServerAction(Component component, JComboBox jComboBox, MutableComboBoxModel mutableComboBoxModel, File file, String string, String string2) {
        Comparable<LocalServer> comparable;
        if (file == null && ((LocalServer)(comparable = (LocalServer)jComboBox.getSelectedItem())).getDocumentRoot() != null && ((LocalServer)comparable).getDocumentRoot().length() > 0) {
            file = new File(((LocalServer)comparable).getDocumentRoot());
        }
        if ((comparable = Utils.browseLocationAction(component, file, string2)) == null) {
            return null;
        }
        Comparable<File> comparable2 = null;
        comparable2 = string == null ? comparable : new File((File)comparable, string);
        String string3 = comparable2.getAbsolutePath();
        for (int i = 0; i < mutableComboBoxModel.getSize(); ++i) {
            LocalServer localServer = (LocalServer)mutableComboBoxModel.getElementAt(i);
            if (!string3.equals(localServer.getSrcRoot())) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        LocalServer localServer = new LocalServer(((File)comparable).getAbsolutePath(), string3);
        mutableComboBoxModel.addElement(localServer);
        jComboBox.setSelectedItem(localServer);
        return comparable;
    }

    public static List getAllItems(final JComboBox jComboBox) {
        return new AbstractList(){

            public Object get(int n) {
                return jComboBox.getItemAt(n);
            }

            public int size() {
                return jComboBox.getItemCount();
            }
        };
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isValidFileName(String string) {
        assert (string != null);
        if (string.trim().length() == 0) {
            return false;
        }
        for (char c : INVALID_FILENAME_CHARS) {
            if (string.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(File file) {
        assert (file != null);
        for (File file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
            if (file2.isAbsolute() && file2.getParentFile() == null) {
                return true;
            }
            if (Utils.isValidFileName(file2.getName())) continue;
            return false;
        }
        return true;
    }

    public static String validateProjectDirectory(String string, String string2, boolean bl, boolean bl2) {
        return Utils.validateProjectDirectory(new File(string), string2, bl, bl2);
    }

    public static String validateProjectDirectory(File file, String string, boolean bl, boolean bl2) {
        File file2;
        File file3;
        assert (file != null);
        assert (string != null);
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + string + "NotAbsolute"));
        }
        if (!bl2 && Utilities.isUnix() && (file3 = Utils.getCanonicalFile(file)) != null && (file3.getParentFile() == null || file3.getParentFile().getParent() == null)) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + string + "InRootNotSupported"));
        }
        file3 = file.getAbsoluteFile();
        if (Utils.getCanonicalFile(file3) == null) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_Illegal" + string + "Location"));
        }
        for (file2 = FileUtil.normalizeFile((File)file3); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + string + "FolderReadOnly"));
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_Illegal" + string + "Location"));
        }
        if (!bl) {
            File[] fileArray = file3.listFiles();
            if (file3.exists() && fileArray != null && fileArray.length > 0) {
                return NbBundle.getMessage(Utils.class, (String)("MSG_" + string + "FolderExists"));
            }
        }
        return null;
    }

    public static String validateSourcesAndCopyTarget(String string, String string2) {
        if (Utils.subdirectories(string, string2)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_SourcesEqualCopyTarget");
        }
        return null;
    }

    public static boolean subdirectories(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string.startsWith(string2) || string2.startsWith(string);
    }

    public static String validateAsciiText(String string, String string2) {
        assert (string2 != null);
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Utils.isAsciiPrintable(string.charAt(i))) continue;
            return NbBundle.getMessage(Utils.class, (String)"MSG_NonAsciiCharacterFound", (Object)string2);
        }
        return null;
    }

    public static boolean isAsciiPrintable(char c) {
        return c >= ' ' && c < '\u007f';
    }

    public static void browseFolderFile(FileObject fileObject, JTextField jTextField) {
        String string = Utils.browseFolderFile(fileObject, jTextField.getText());
        if (string != null) {
            jTextField.setText(string);
        }
    }

    public static String browseFolderFile(FileObject fileObject, String string) {
        FileObject fileObject2 = BrowseFolders.showDialog(new FileObject[]{fileObject}, DataObject.class, Utils.securePreselected(string, true));
        if (fileObject2 != null) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)fileObject), (File)FileUtil.toFile((FileObject)fileObject2));
        }
        return null;
    }

    public static void browseSourceFile(Project project, JTextField jTextField) {
        String string = Utils.browseSource(project, jTextField.getText(), false);
        if (string != null) {
            jTextField.setText(string);
        }
    }

    public static String browseSourceFile(Project project, String string) {
        return Utils.browseSource(project, string, false);
    }

    public static void browseSourceFolder(Project project, JTextField jTextField) {
        String string = Utils.browseSource(project, jTextField.getText(), true);
        if (string != null) {
            jTextField.setText(string);
        }
    }

    public static String browseSourceFolder(Project project, String string) {
        return Utils.browseSource(project, string, true);
    }

    private static String browseSource(Project project, String string, boolean bl) {
        SourceGroup[] sourceGroupArray = org.netbeans.modules.php.project.Utils.getSourceGroups(project);
        assert (sourceGroupArray.length == 1);
        assert (sourceGroupArray[0] != null);
        File file = FileUtil.toFile((FileObject)sourceGroupArray[0].getRootFolder());
        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray, bl ? DataFolder.class : DataObject.class, Utils.securePreselected(string, !bl));
        if (fileObject != null) {
            return PropertyUtils.relativizeFile((File)file, (File)FileUtil.toFile((FileObject)fileObject));
        }
        return null;
    }

    private static String securePreselected(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.length() > 0) {
            string2 = string.replace(File.separatorChar, '/');
            if (bl) {
                string2 = string2.substring(0, string2.lastIndexOf("."));
            }
        }
        return string2;
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String string) {
            super(string, new String[0]);
        }

        public boolean contains(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    public static class EncodingRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 3196531352192214602L;

        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof Charset);
            this.setName("ComboBox.listRenderer");
            this.setText(((Charset)object).displayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    public static class EncodingModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -3139920099217726436L;

        public EncodingModel() {
            this((String)null);
        }

        public EncodingModel(String string) {
            Charset charset = null;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (charset2.name().equals(string)) {
                    charset = charset2;
                }
                this.addElement(charset2);
            }
            if (charset == null && string != null) {
                try {
                    charset = new UnknownCharset(string);
                    this.addElement(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Logger.getLogger(EncodingModel.class.getName()).info("IllegalCharsetName: " + string);
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            this.setSelectedItem(charset);
        }
    }
}

