/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.Utils;
import org.netbeans.modules.php.project.ui.actions.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.Displayable;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class Command {
    private final PhpProject project;

    public Command(PhpProject phpProject) {
        this.project = phpProject;
        assert (phpProject != null);
    }

    public abstract String getCommandId();

    public abstract void invokeAction(Lookup var1) throws IllegalArgumentException;

    public abstract boolean isActionEnabled(Lookup var1) throws IllegalArgumentException;

    public boolean asyncCallRequired() {
        return true;
    }

    public boolean saveRequired() {
        return true;
    }

    public final PhpProject getProject() {
        return this.project;
    }

    protected final void showURLForContext(Lookup lookup) throws MalformedURLException {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.urlForContext(lookup));
    }

    protected final void showURLForProjectFile() throws MalformedURLException {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.urlForProjectFile());
    }

    protected final void showURLForDebugProjectFile() throws MalformedURLException {
        this.showURLForDebugContext(null);
    }

    protected final void showURLForDebugContext(Lookup lookup) throws MalformedURLException {
        URL uRL;
        boolean bl = WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project);
        boolean bl2 = WebClientToolsProjectUtils.getClientDebugProperty((Project)this.project);
        if (!WebClientToolsSessionStarterService.isAvailable()) {
            bl = true;
            bl2 = false;
        }
        assert (bl || bl2);
        if (lookup != null) {
            uRL = bl ? this.urlForDebugContext(lookup) : this.urlForContext(lookup);
        } else {
            URL uRL2 = uRL = bl ? this.urlForDebugProjectFile() : this.urlForProjectFile();
        }
        if (bl2) {
            try {
                this.launchJavaScriptDebugger(uRL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    protected final void launchJavaScriptDebugger(URL uRL) throws MalformedURLException, URISyntaxException {
        HtmlBrowser.Factory factory;
        URI uRI;
        LocationMappersFactory locationMappersFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
        Lookup lookup = null;
        if (locationMappersFactory != null) {
            uRI = this.getBaseURL().toURI();
            factory = Utils.getSourceObjects(this.getProject());
            JSToNbJSLocationMapper jSToNbJSLocationMapper = locationMappersFactory.getJSToNbJSLocationMapper((FileObject[])factory, uRI, null);
            NbJSToJSLocationMapper nbJSToJSLocationMapper = locationMappersFactory.getNbJSToJSLocationMapper((FileObject[])factory, uRI, null);
            lookup = Lookups.fixed((Object[])new Object[]{jSToNbJSLocationMapper, nbJSToJSLocationMapper, this.project});
        } else {
            lookup = Lookups.fixed((Object[])new Object[]{this.project});
        }
        uRI = uRL.toURI();
        factory = null;
        factory = WebClientToolsProjectUtils.isInternetExplorer((Project)this.project) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
        if (factory == null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        } else {
            try {
                WebClientToolsSessionStarterService.startSession((URI)uRI, (HtmlBrowser.Factory)factory, (Lookup)lookup);
            }
            catch (WebClientToolsSessionException webClientToolsSessionException) {
                Exceptions.printStackTrace((Throwable)webClientToolsSessionException);
            }
        }
    }

    protected final String getProperty(String string) {
        return this.getPropertyEvaluator().getProperty(string);
    }

    protected final URL getBaseURL() throws MalformedURLException {
        String string = this.getProperty("url");
        if (string == null) {
            throw new MalformedURLException();
        }
        return new URL(string);
    }

    protected final URL appendQuery(URL uRL, String string) throws MalformedURLException {
        try {
            URI uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), string, uRL.getRef());
            return uRI.toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getLocalizedMessage());
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    protected final URL urlForDebugProjectFile() throws MalformedURLException {
        return this.appendQuery(this.urlForProjectFile(), "XDEBUG_SESSION_START=netbeans-xdebug");
    }

    protected final URL urlForDebugContext(Lookup lookup) throws MalformedURLException {
        return this.appendQuery(this.urlForContext(lookup), "XDEBUG_SESSION_START=netbeans-xdebug");
    }

    protected final URL urlForProjectFile() throws MalformedURLException {
        String string = this.relativePathForProject();
        if (string == null) {
            string = "";
        }
        URL uRL = new URL(this.getBaseURL(), string);
        String string2 = this.getProperty("script.arguments");
        return string2 != null ? this.appendQuery(uRL, string2) : uRL;
    }

    protected final URL urlForContext(Lookup lookup) throws MalformedURLException {
        String string = this.relativePathForConext(lookup);
        if (string == null) {
            throw new MalformedURLException();
        }
        URL uRL = new URL(this.getBaseURL(), string);
        String string2 = this.getProperty("script.arguments");
        return string2 != null ? this.appendQuery(uRL, string2) : uRL;
    }

    protected final String relativePathForConext(Lookup lookup) {
        return this.getCommandUtils().getRelativeWebRootPath(this.fileForContext(lookup), this.getProperty("web.root"));
    }

    protected final String relativePathForProject() {
        return this.getCommandUtils().getRelativeWebRootPath(this.fileForProject(), this.getProperty("web.root"));
    }

    protected final FileObject fileForProject() {
        FileObject fileObject;
        FileObject[] fileObjectArray;
        FileObject fileObject2 = null;
        String string = this.getProperty("index.file");
        FileObject[] fileObjectArray2 = fileObjectArray = Utils.getSourceObjects(this.getProject());
        int n = fileObjectArray2.length;
        for (int i = 0; i < n && (fileObject2 = (fileObject = fileObjectArray2[i]).getFileObject(string)) == null; ++i) {
        }
        return fileObject2;
    }

    protected boolean isScriptSelected() {
        String string = this.getPropertyEvaluator().getProperty("run.as");
        return PhpProjectProperties.RunAsType.SCRIPT.name().equals(string);
    }

    protected String getPhpInterpreter() {
        String string = PhpOptions.getInstance().getPhpInterpreter();
        return string != null && string.length() > 0 ? string.trim() : null;
    }

    protected boolean isRemoteConfigSelected() {
        String string = this.getPropertyEvaluator().getProperty("run.as");
        return PhpProjectProperties.RunAsType.REMOTE.name().equals(string);
    }

    protected String getRemoteConfigurationName() {
        return this.getPropertyEvaluator().getProperty("remote.connection");
    }

    protected String getRemoteDirectory() {
        return this.getPropertyEvaluator().getProperty("remote.directory");
    }

    protected final FileObject fileForContext(Lookup lookup) {
        CommandUtils commandUtils = this.getCommandUtils();
        FileObject[] fileObjectArray = commandUtils.phpFilesForContext(lookup, this.isScriptSelected(), this.getProperty("web.root"));
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            fileObjectArray = commandUtils.phpFilesForSelectedNodes(this.isScriptSelected(), this.getProperty("web.root"));
        }
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    protected final Command getOtherCommand(String string) {
        PhpActionProvider phpActionProvider = (PhpActionProvider)this.getProject().getLookup().lookup(PhpActionProvider.class);
        assert (phpActionProvider != null);
        return phpActionProvider.getCommand(string);
    }

    private CommandUtils getCommandUtils() {
        CommandUtils commandUtils = new CommandUtils(this.getProject());
        return commandUtils;
    }

    private static OutputWriter getOutputWriter(String string, boolean bl, boolean bl2) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        if (bl2) {
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl ? inputOutput.getErr() : inputOutput.getOut();
    }

    protected final BufferedReader reader(InputStream inputStream, Charset charset) {
        return new BufferedReader(new InputStreamReader(inputStream, charset));
    }

    protected final BufferedWriter outputTabWriter(File file, boolean bl, boolean bl2) {
        String string = this.getOutputTabTitle(file);
        OutputWriter outputWriter = Command.getOutputWriter(string, bl, bl2);
        return new BufferedWriter((Writer)outputWriter);
    }

    protected final String getOutputTabTitle(File file) {
        return this.getOutputTabTitle(((Displayable)((Object)this)).getDisplayName(), file);
    }

    protected String getOutputTabTitle(String string, File file) {
        assert (this instanceof Displayable);
        return MessageFormat.format("{0} - {1}", string, file.getName());
    }

    protected static final BufferedWriter writer(OutputStream outputStream, Charset charset) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void rewriteAndClose(StringConvertor stringConvertor, BufferedReader bufferedReader, BufferedWriter ... bufferedWriterArray) throws IOException {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                string = stringConvertor != null ? stringConvertor.convert(string) : string;
                for (BufferedWriter bufferedWriter : bufferedWriterArray) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
            }
        }
        finally {
            bufferedReader.close();
            for (BufferedWriter bufferedWriter : bufferedWriterArray) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
    }

    private PropertyEvaluator getPropertyEvaluator() {
        return this.getProject().getEvaluator();
    }

    public static interface StringConvertor {
        public String convert(String var1);
    }
}

