/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class RunAsScript
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -5593489197914071L;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    private final PropertyChangeListener phpInterpreterListener;
    final ProjectCustomizer.Category category;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JButton configureButton;
    private JLabel hintLabel;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JLabel interpreterLabel;
    private JTextField interpreterTextField;
    private JComboBox runAsCombo;
    private JLabel runAsLabel;

    public RunAsScript(PhpProject phpProject, ConfigManager configManager, ProjectCustomizer.Category category) {
        this(phpProject, configManager, category, NbBundle.getMessage(RunAsScript.class, (String)"LBL_ConfigScript"));
    }

    private RunAsScript(PhpProject phpProject, ConfigManager configManager, ProjectCustomizer.Category category, String string) {
        super(configManager);
        this.project = phpProject;
        this.category = category;
        this.displayName = string;
        this.initComponents();
        this.labels = new JLabel[]{this.indexFileLabel, this.argsLabel};
        this.textFields = new JTextField[]{this.indexFileTextField, this.argsTextField};
        this.propertyNames = new String[]{"index.file", "script.arguments"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
        this.loadPhpInterpreter();
        this.phpInterpreterListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("propPhpInterpreter".equals(propertyChangeEvent.getPropertyName())) {
                    RunAsScript.this.loadPhpInterpreter();
                    RunAsScript.this.composeHint();
                    RunAsScript.this.validateFields();
                }
            }
        };
        PhpOptions phpOptions = PhpOptions.getInstance();
        phpOptions.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.phpInterpreterListener, (Object)phpOptions));
        this.composeHint();
    }

    void loadPhpInterpreter() {
        this.interpreterTextField.setText(PhpOptions.getInstance().getPhpInterpreter());
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.SCRIPT;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    public JComboBox getRunAsCombo() {
        return this.runAsCombo;
    }

    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
    }

    protected void validateFields() {
        String string = this.interpreterTextField.getText().trim();
        String string2 = this.argsTextField.getText().trim();
        String string3 = RunAsValidator.validateScriptFields(string, null, string2);
        this.category.setErrorMessage(string3);
        this.category.setValid(string3 == null);
    }

    void composeHint() {
        String string = this.interpreterTextField.getText();
        String string2 = "./" + this.indexFileTextField.getText();
        String string3 = this.argsTextField.getText();
        this.hintLabel.setText(string + " " + string2 + " " + string3);
    }

    private void initComponents() {
        this.interpreterLabel = new JLabel();
        this.interpreterTextField = new JTextField();
        this.configureButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.hintLabel = new JLabel();
        this.interpreterLabel.setLabelFor(this.interpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.interpreterLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_PhpInterpreter"));
        this.interpreterTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Configure"));
        this.configureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.configureButtonActionPerformed(actionEvent);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Arguments"));
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_RunAs"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"dummy");
        this.hintLabel.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.runAsLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.interpreterLabel).add((Component)this.indexFileLabel).add((Component)this.argsLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.hintLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.argsTextField, -1, 222, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indexFileTextField, -1, 111, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.indexFileBrowseButton)).add(2, (Component)this.runAsCombo, 0, 222, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.interpreterTextField, -1, 111, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.configureButton))).add(0, 0, 0)))));
        groupLayout.linkSize(new Component[]{this.configureButton, this.indexFileBrowseButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsLabel).add((Component)this.runAsCombo, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.interpreterLabel).add((Component)this.interpreterTextField, -2, -1, -2).add((Component)this.configureButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.indexFileTextField, -2, 19, -2).add((Component)this.indexFileLabel).add((Component)this.indexFileBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.argsTextField, -2, 19, -2).add((Component)this.argsLabel)).addPreferredGap(0).add((Component)this.hintLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void configureButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory");
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseSourceFile((Project)this.project, this.indexFileTextField);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsScript.this.getDefaultValue(this.getPropName());
        }

        protected void processUpdate() {
            super.processUpdate();
            RunAsScript.this.composeHint();
        }
    }
}

