/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.io.IOException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class PhpOptions {
    public static final int DEFAULT_DEBUGGER_PORT = 9000;
    public static final boolean DEFAULT_DEBUGGER_STOP_AT_FIRST_LINE = true;
    public static final String PHP_INTERPRETER = "phpInterpreter";
    public static final String PHP_OPEN_IN_OUTPUT = "phpOpenInOutput";
    public static final String PHP_OPEN_IN_BROWSER = "phpOpenInBrowser";
    public static final String PHP_OPEN_IN_EDITOR = "phpOpenInEditor";
    public static final String PHP_DEBUGGER_PORT = "phpDebuggerPort";
    public static final String PHP_DEBUGGER_STOP_AT_FIRST_LINE = "phpDebuggerStopAtFirstLine";
    public static final String PHP_GLOBAL_INCLUDE_PATH = "phpGlobalIncludePath";
    private static final PhpOptions INSTANCE = new PhpOptions();
    private boolean phpInterpreterSearched = false;

    private PhpOptions() {
    }

    public static PhpOptions getInstance() {
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(PhpOptions.class);
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.getPreferences().addPreferenceChangeListener(preferenceChangeListener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.getPreferences().removePreferenceChangeListener(preferenceChangeListener);
    }

    public synchronized String getPhpInterpreter() {
        String string = this.getPreferences().get(PHP_INTERPRETER, null);
        if (string == null && !this.phpInterpreterSearched) {
            this.phpInterpreterSearched = true;
            string = PhpEnvironment.get().getAnyPhpInterpreter();
            if (string != null) {
                this.setPhpInterpreter(string);
            }
        }
        return string;
    }

    public void setPhpInterpreter(String string) {
        this.getPreferences().put(PHP_INTERPRETER, string);
    }

    public boolean isOpenResultInOutputWindow() {
        return this.getPreferences().getBoolean(PHP_OPEN_IN_OUTPUT, true);
    }

    public void setOpenResultInOutputWindow(boolean bl) {
        this.getPreferences().putBoolean(PHP_OPEN_IN_OUTPUT, bl);
    }

    public boolean isOpenResultInBrowser() {
        return this.getPreferences().getBoolean(PHP_OPEN_IN_BROWSER, false);
    }

    public void setOpenResultInBrowser(boolean bl) {
        this.getPreferences().putBoolean(PHP_OPEN_IN_BROWSER, bl);
    }

    public boolean isOpenResultInEditor() {
        return this.getPreferences().getBoolean(PHP_OPEN_IN_EDITOR, false);
    }

    public void setOpenResultInEditor(boolean bl) {
        this.getPreferences().putBoolean(PHP_OPEN_IN_EDITOR, bl);
    }

    public int getDebuggerPort() {
        return this.getPreferences().getInt(PHP_DEBUGGER_PORT, 9000);
    }

    public void setDebuggerPort(int n) {
        this.getPreferences().putInt(PHP_DEBUGGER_PORT, n);
    }

    public boolean isDebuggerStoppedAtTheFirstLine() {
        return this.getPreferences().getBoolean(PHP_DEBUGGER_STOP_AT_FIRST_LINE, true);
    }

    public void setDebuggerStoppedAtTheFirstLine(boolean bl) {
        this.getPreferences().putBoolean(PHP_DEBUGGER_STOP_AT_FIRST_LINE, bl);
    }

    public String getPhpGlobalIncludePath() {
        String string = this.getPreferences().get(PHP_GLOBAL_INCLUDE_PATH, null);
        if (string == null) {
            this.setPhpGlobalIncludePath("");
            string = "";
        }
        return string;
    }

    public void setPhpGlobalIncludePath(String string) {
        this.getPreferences().put(PHP_GLOBAL_INCLUDE_PATH, string);
        EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
        editableProperties.setProperty("php.global.include.path", string);
        try {
            PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

