/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.css.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BackgroundImageUrlDialog {
    private static final Logger LOGGER = Logger.getLogger(BackgroundImageUrlDialog.class.getName());
    private File base;
    private String imageUrl = null;
    private FileFilter imgFilter = new ImageFilter();

    public BackgroundImageUrlDialog(File file) {
        this.base = file;
    }

    public boolean show(Component component) {
        boolean bl = false;
        JFileChooser jFileChooser = Utilities.getJFileChooser();
        try {
            Object var4_4 = null;
            FileObject fileObject = FileUtil.toFileObject((File)this.base);
            if (fileObject != null) {
                jFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)fileObject));
            }
            jFileChooser.addChoosableFileFilter(new ImageFilter());
            if (jFileChooser.showOpenDialog(component) == 0) {
                File file = jFileChooser.getSelectedFile();
                FileObject fileObject2 = FileUtil.toFileObject((File)file);
                if (fileObject2 == null) {
                    LOGGER.log(Level.WARNING, null, new IllegalStateException("Cannot find FileObject for file " + file.toURL()));
                    return false;
                }
                FileObject fileObject3 = fileObject2.getParent();
                String string = null;
                FileObject fileObject4 = fileObject;
                int n = 0;
                do {
                    ++n;
                    if ((fileObject4 = fileObject4.getParent()) == null) break;
                    string = FileUtil.getRelativePath((FileObject)fileObject4, (FileObject)fileObject3);
                    if (!fileObject4.equals(var4_4) || string != null) continue;
                    FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)fileObject2.getName(), (String)fileObject2.getExt());
                    this.imageUrl = fileObject2.getNameExt();
                    return true;
                } while (string == null);
                if (string == null) {
                    return false;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.makePrefix(n));
                stringBuilder.append(string);
                if (string.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(fileObject2.getNameExt());
                this.imageUrl = this.encodeURL(stringBuilder.toString());
                bl = true;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
        }
        return bl;
    }

    private String makePrefix(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("../");
        }
        return stringBuilder.toString();
    }

    private String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public static class ImageFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            if (string != null) {
                return string.toLowerCase().equals("gif") || string.toLowerCase().equals("jpg") || string.toLowerCase().equals("png");
            }
            return false;
        }

        public String getDescription() {
            return NbBundle.getMessage(BackgroundImageUrlDialog.class, (String)"IMAGE_FILTER");
        }
    }
}

