/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.core;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.xml.search.api.SearchManager;
import org.netbeans.modules.xml.search.impl.action.SearchAction;
import org.netbeans.modules.xml.search.impl.ui.Find;
import org.netbeans.modules.xml.search.impl.ui.Search;
import org.netbeans.modules.xml.search.spi.SearchEngine;
import org.netbeans.modules.xml.search.spi.SearchProvider;
import org.netbeans.modules.xml.ui.UI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Manager
extends SearchManager {
    private Search mySearch;
    private List<SearchEngine> myEngines = UI.getInstances(SearchEngine.class);

    public Manager() {
        this.mySearch = new Search();
    }

    @Override
    public void showSearch(SearchProvider searchProvider) {
        if (searchProvider == null) {
            return;
        }
        List<SearchEngine> list = this.getEngines(searchProvider.getRoot());
        if (list.isEmpty()) {
            return;
        }
        this.mySearch.show(list.get(0), searchProvider);
    }

    @Override
    public Component createFind(Object object, JComponent jComponent) {
        List<SearchEngine> list = this.getEngines(object);
        if (list.isEmpty()) {
            return null;
        }
        return new Find(list, object, jComponent);
    }

    @Override
    public Action getSearchAction() {
        return SearchAction.DEFAULT;
    }

    private List<SearchEngine> getEngines(Object object) {
        LinkedList<SearchEngine> linkedList = new LinkedList<SearchEngine>();
        for (SearchEngine searchEngine : this.myEngines) {
            if (!searchEngine.isApplicable(object)) continue;
            linkedList.add(searchEngine);
        }
        return linkedList;
    }
}

