/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.xml.ui.UI;
import org.openide.DialogDescriptor;
import org.openide.awt.HtmlBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Export
extends UI.Dialog {
    private String myTitle;
    private JTextField myFileName;
    private JCheckBox myRunBrowser;
    private JTextArea myDescription;
    private List<List<String>> myItems;
    private DialogDescriptor myDescriptor;
    private static final String SE = "search";
    private static final String RE = "result.html";
    private static final String HTM_EXT = ".htm";
    private static final String HTML_EXT = ".html";
    private static final int TEXT_WIDTH = 30;
    private static final int TEXT_HEIGHT = 10;

    public void show(List<List<String>> list, String string) {
        this.myItems = list;
        this.myTitle = string;
        this.show();
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 2, 2, 3);
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_File_Name")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 2, 2, 8);
        gridBagConstraints.fill = 2;
        this.myFileName = new JTextField(30);
        this.myFileName.setText(this.getResultFolder());
        jPanel.add((Component)this.myFileName, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 2, 5);
        gridBagConstraints.fill = 0;
        JButton jButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Browse"), this.i18n("TLT_Browse")){

            public void actionPerformed(ActionEvent actionEvent) {
                Export.this.selectFile();
            }
        });
        Dimension dimension = this.myFileName.getPreferredSize();
        dimension.width = dimension.height;
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 2, 3, 5);
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Description")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 2, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.myDescription = new JTextArea(10, 1);
        jPanel.add((Component)new JScrollPane(this.myDescription), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints.fill = 0;
        this.myRunBrowser = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Open_in_Browser")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.myRunBrowser.setSelected(true);
        jPanel.add((Component)this.myRunBrowser, gridBagConstraints);
        return jPanel;
    }

    private void checkFolder(File file) {
        if (file == null || file.exists()) {
            return;
        }
        this.checkFolder(file.getParentFile());
        file.mkdir();
    }

    private void createFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (UI.printWarning(this.i18n("LBL_File_Exists", string))) {
                this.exportFile(file);
            } else {
                this.show();
            }
        } else {
            this.exportFile(file);
        }
    }

    private void selectFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(Export.HTML_EXT) || file.isDirectory();
            }

            public String getDescription() {
                return Export.this.i18n("LBL_HTML_File_Type");
            }
        });
        jFileChooser.setSelectedFile(new File(this.myFileName.getText()));
        if (jFileChooser.showOpenDialog(this.getUIComponent()) == 0) {
            this.myFileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void exportFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>" + UI.LS);
        if (this.myTitle != null) {
            stringBuffer.append("<title>" + UI.removeHtml(this.myTitle) + "</title>" + UI.LS);
        }
        stringBuffer.append("<body>" + UI.LS);
        stringBuffer.append("<h3>" + this.i18n("LBL_Search_Results") + "</h3>" + UI.LS + UI.LS);
        if (this.myTitle != null) {
            stringBuffer.append(this.myTitle + UI.LS + UI.LS);
        }
        stringBuffer.append("<p><b>" + this.i18n("LBL_Description") + "</b>" + UI.LS);
        stringBuffer.append("<pre>" + UI.LS);
        stringBuffer.append(this.myDescription.getText() + UI.LS);
        stringBuffer.append("</pre>" + UI.LS);
        int n = 1;
        stringBuffer.append(UI.LS + "<p><table border=1>" + UI.LS);
        for (List<String> list : this.myItems) {
            if (list == null) {
                stringBuffer.append("</table>" + UI.LS);
                stringBuffer.append(UI.LS + "<p><table border=1>" + UI.LS);
                n = 1;
                continue;
            }
            stringBuffer.append("<tr><td>" + n++ + "</td>");
            for (String string : list) {
                stringBuffer.append(" <td>" + this.processBrackets(string) + "</td>");
            }
            stringBuffer.append("</tr>" + UI.LS);
        }
        stringBuffer.append("</table>" + UI.LS + UI.LS);
        stringBuffer.append("</body>" + UI.LS);
        stringBuffer.append("</html>" + UI.LS);
        this.writeToFile(file, stringBuffer.toString());
    }

    private void writeToFile(File file, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            UI.printError(this.i18n("ERR_Can_not_Write_to_File", file.getAbsolutePath()));
            this.show();
            return;
        }
        if (this.myRunBrowser.isSelected()) {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                UI.printError(this.i18n("ERR_Can_not_Open_File", file.getAbsolutePath()));
            }
        }
    }

    @Override
    protected final DialogDescriptor createDescriptor() {
        this.myDescriptor = new DialogDescriptor((Object)this.createPanel(), this.i18n("LBL_Export_Title"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Export.this.close();
            }
        });
        return this.myDescriptor;
    }

    private String getResultFolder() {
        return UI.UH + UI.FS + SE + UI.FS + RE;
    }

    @Override
    protected final void opened() {
        this.myFileName.requestFocus();
    }

    private void close() {
        if (this.myDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        String string = this.myFileName.getText().toLowerCase();
        if (!string.endsWith(HTM_EXT) && !string.endsWith(HTML_EXT)) {
            string = string + HTML_EXT;
        }
        this.checkFolder(new File(string).getParentFile());
        this.createFile(string);
    }

    private String processBrackets(String string) {
        return this.processLBrackets(this.processRBrackets(string));
    }

    private String processBrackets(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + string3 + this.processBrackets(string.substring(n + 1), string2, string3);
    }

    private String processLBrackets(String string) {
        return this.processBrackets(string, "<", "&lt;");
    }

    private String processRBrackets(String string) {
        return this.processBrackets(string, ">", "&gt;");
    }
}

