/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

final class Field {
    private JComboBox myComboBox;
    private List<String> myItems = new LinkedList<String>();
    private ActionListener myActionListener;
    private static final int MAX_SIZE = 15;
    private static final String DELIM = "\u007f";

    Field(String string) {
        this.createUIComponent();
        this.setItems(string);
    }

    public String getText() {
        return (String)this.myComboBox.getEditor().getItem();
    }

    public void requestFocus() {
        this.myComboBox.getEditor().getEditorComponent().requestFocus();
    }

    public String save() {
        this.addItem((String)this.myComboBox.getEditor().getItem());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.myItems.size(); ++i) {
            stringBuffer.append((i == 0 ? "" : DELIM) + this.myItems.get(i));
            if (i == 15) break;
        }
        return stringBuffer.toString();
    }

    public void addActionListener(ActionListener actionListener) {
        this.myActionListener = actionListener;
    }

    public JComponent getUIComponent() {
        return this.myComboBox;
    }

    private void addItem(String string) {
        if (string == null) {
            this.select();
            return;
        }
        this.myComboBox.removeAllItems();
        if (this.myItems.contains(string)) {
            this.myItems.remove(string);
        }
        this.myItems.add(0, string);
        for (int i = 0; i < this.myItems.size() && i != 15; ++i) {
            this.myComboBox.addItem(this.myItems.get(i));
        }
        this.myComboBox.setSelectedItem(string);
        this.select();
    }

    private void setItems(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith(DELIM) && !this.myItems.contains("")) {
            this.myItems.add("");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.myItems.contains(string2)) continue;
            this.myItems.add(string2);
        }
        this.myComboBox.removeAllItems();
        for (int i = 0; i < this.myItems.size(); ++i) {
            this.myComboBox.addItem(this.myItems.get(i));
            if (i == 15) break;
        }
        if (this.myItems.size() > 0) {
            this.myComboBox.setSelectedItem(this.myItems.get(0));
        }
        this.select();
    }

    private void createUIComponent() {
        this.myComboBox = new JComboBox();
        this.myComboBox.setEditable(true);
        this.myComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (Field.this.myActionListener != null) {
                    Field.this.myActionListener.actionPerformed(new ActionEvent(Field.this.myComboBox.getEditor().getItem(), 0, null));
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                JRootPane jRootPane;
                if (keyEvent.getKeyCode() == 10 && !Field.this.myComboBox.isPopupVisible() && (jRootPane = SwingUtilities.getRootPane(Field.this.myComboBox)) != null) {
                    jRootPane.dispatchEvent(keyEvent);
                }
            }
        });
    }

    private void select() {
        this.myComboBox.getEditor().selectAll();
    }
}

