/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.feedreader;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.apisupport.feedreader.FeedReaderWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FeedReaderPanelVisual
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    private FeedReaderWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public FeedReaderPanelVisual(FeedReaderWizardPanel feedReaderWizardPanel) {
        this.initComponents();
        this.panel = feedReaderWizardPanel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"LBL_ProjectName"));
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"LBL_ProjectLocation"));
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FeedReaderPanelVisual.this.browseLocationAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"LBL_Browse"));
        this.add((Component)this.browseButton, gridBagConstraints);
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"LBL_ProjectFolder"));
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"LBL_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"MSG_InvalidProjectFolderName"));
            return false;
        }
        File file3 = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!file3.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"MSG_InvalidProjectFolderPath"));
            return false;
        }
        for (file2 = file = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"MSG_CanNotCreateProjectFolder"));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"MSG_InvalidProjectFolderPath"));
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)FeedReaderPanelVisual.class, (String)"MSG_ProjectFolderAlreadyExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            string = "feedreader-suite";
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        }
        this.panel.fireChangeEvent();
    }
}

