/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathContainerResolver {
    public static final String JUNIT_CONTAINER = "org.eclipse.jdt.junit.JUNIT_CONTAINER/";
    public static final String USER_LIBRARY_CONTAINER = "org.eclipse.jdt.USER_LIBRARY/";
    public static final String WEB_CONTAINER = "org.eclipse.jst.j2ee.internal.web.container";
    public static final String J2EE_MODULE_CONTAINER = "org.eclipse.jst.j2ee.internal.module.container";
    public static final String JSF_CONTAINER = "org.eclipse.jst.jsf.core.internal.jsflibrarycontainer/";
    public static final String J2EE_SERVER_CONTAINER = "org.eclipse.jst.server.core.container/";
    public static final String MYECLIPSE_CONTAINERS = "melibrary.com.genuitec.eclipse.";

    public static boolean resolve(Workspace workspace, DotClassPathEntry dotClassPathEntry, List<String> list, boolean bl) throws IOException {
        assert (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.CONTAINER) : dotClassPathEntry;
        String string = dotClassPathEntry.getRawPath();
        if (string.startsWith(JUNIT_CONTAINER)) {
            String string2 = "libs.junit.classpath";
            if (string.substring(JUNIT_CONTAINER.length()).startsWith("4")) {
                string2 = "libs.junit_4.classpath";
            }
            dotClassPathEntry.setContainerMapping(string2);
            return true;
        }
        if (string.startsWith(USER_LIBRARY_CONTAINER)) {
            if (bl) {
                ClassPathContainerResolver.createLibrary(workspace, string, list);
            }
            dotClassPathEntry.setContainerMapping("libs." + ClassPathContainerResolver.getNetBeansLibraryName(string) + ".classpath");
            return true;
        }
        if (string.startsWith(JSF_CONTAINER)) {
            if (bl) {
                ClassPathContainerResolver.createLibrary(workspace, string, list);
            }
            dotClassPathEntry.setContainerMapping("libs." + ClassPathContainerResolver.getNetBeansLibraryName(string) + ".classpath");
            return true;
        }
        if (string.startsWith(J2EE_MODULE_CONTAINER) || string.startsWith(J2EE_SERVER_CONTAINER)) {
            dotClassPathEntry.setContainerMapping("");
            return true;
        }
        if (string.startsWith(MYECLIPSE_CONTAINERS)) {
            if (bl) {
                if (workspace != null) {
                    workspace.loadMyEclipseLibraries(list);
                }
                ClassPathContainerResolver.createLibrary(workspace, string, list);
            }
            dotClassPathEntry.setContainerMapping("libs." + ClassPathContainerResolver.getNetBeansLibraryName(string) + ".classpath");
            return true;
        }
        if (string.startsWith(WEB_CONTAINER)) {
            if (bl) {
                assert (workspace == null);
                list.add(NbBundle.getMessage(ClassPathContainerResolver.class, (String)"MSG_UnsupportedWebContainer", (Object)string));
                return false;
            }
            return true;
        }
        list.add(NbBundle.getMessage(ClassPathContainerResolver.class, (String)"MSG_UnsupportedContainer", (Object)string));
        return false;
    }

    public static List<DotClassPathEntry> replaceContainerEntry(EclipseProject eclipseProject, Workspace workspace, DotClassPathEntry dotClassPathEntry, List<String> list) {
        assert (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.CONTAINER) : dotClassPathEntry;
        String string = dotClassPathEntry.getRawPath();
        if (string.startsWith(WEB_CONTAINER)) {
            String string2 = null;
            if (string.length() > WEB_CONTAINER.length()) {
                string2 = string.substring(WEB_CONTAINER.length() + 1);
            }
            return ClassPathContainerResolver.createClassPathForWebContainer(eclipseProject, workspace, string2);
        }
        return null;
    }

    private static List<DotClassPathEntry> createClassPathForWebContainer(EclipseProject eclipseProject, Workspace workspace, String string) {
        Object object;
        EclipseProject eclipseProject2;
        ArrayList<DotClassPathEntry> arrayList = new ArrayList<DotClassPathEntry>();
        EclipseProject eclipseProject3 = eclipseProject2 = string != null ? workspace.getProjectByName(string) : eclipseProject;
        if (eclipseProject2 == null) {
            return arrayList;
        }
        if (!eclipseProject2.isImportSupported()) {
            return arrayList;
        }
        File file = eclipseProject2.getProjectFileLocation("webinf");
        if (file == null) {
            return arrayList;
        }
        File file2 = new File(file, "lib");
        if (file2.exists()) {
            object = file2.listFiles();
            int n = ((File[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                if (!((File)object2).isFile()) continue;
                arrayList.add(ClassPathContainerResolver.createFileDotClassPathEntry((File)object2));
            }
        }
        if (((File)(object = new File(file, "classes"))).exists() && ((File)object).isDirectory()) {
            arrayList.add(ClassPathContainerResolver.createFileDotClassPathEntry((File)object));
        }
        return arrayList;
    }

    private static DotClassPathEntry createFileDotClassPathEntry(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("kind", "lib");
        hashMap.put("path", file.getPath());
        DotClassPathEntry dotClassPathEntry = new DotClassPathEntry(hashMap, null);
        dotClassPathEntry.setAbsolutePath(file.getPath());
        return dotClassPathEntry;
    }

    private static String getNetBeansLibraryName(String string) {
        return PropertyUtils.getUsablePropertyName((String)ClassPathContainerResolver.getEclipseLibraryName(string));
    }

    private static String getEclipseLibraryName(String string) {
        if (string.startsWith(MYECLIPSE_CONTAINERS)) {
            int n = string.indexOf(".MYECLIPSE_");
            if (n == -1) {
                n = string.lastIndexOf(".");
                if (n != -1) {
                    ++n;
                }
            } else {
                n += 11;
            }
            assert (n != -1) : string;
            return string.substring(n);
        }
        String string2 = string.startsWith(USER_LIBRARY_CONTAINER) ? USER_LIBRARY_CONTAINER : JSF_CONTAINER;
        return string.substring(string2.length());
    }

    private static void createLibrary(Workspace workspace, String string, List<String> list) throws IOException {
        assert (string.startsWith(USER_LIBRARY_CONTAINER) || string.startsWith(JSF_CONTAINER) || string.startsWith(MYECLIPSE_CONTAINERS)) : string;
        String string2 = ClassPathContainerResolver.getNetBeansLibraryName(string);
        LibraryManager libraryManager = LibraryManager.getDefault();
        if (libraryManager.getLibrary(string2) != null) {
            return;
        }
        HashMap<String, List<URL>> hashMap = new HashMap<String, List<URL>>();
        if (workspace == null) {
            list.add(NbBundle.getMessage(ClassPathContainerResolver.class, (String)"MSG_CannotCreateUserLibrary", (Object)string2));
            return;
        }
        hashMap.put("classpath", workspace.getJarsForUserLibrary(ClassPathContainerResolver.getEclipseLibraryName(string)));
        libraryManager.createLibrary("j2se", string2, hashMap);
    }

    public static boolean isJUnit(DotClassPathEntry dotClassPathEntry) {
        int n;
        if (dotClassPathEntry.getKind() == DotClassPathEntry.Kind.CONTAINER && dotClassPathEntry.getRawPath().startsWith(JUNIT_CONTAINER)) {
            return true;
        }
        if ((dotClassPathEntry.getKind() == DotClassPathEntry.Kind.LIBRARY || dotClassPathEntry.getKind() == DotClassPathEntry.Kind.VARIABLE) && (n = dotClassPathEntry.getRawPath().replace('\\', '/').lastIndexOf(47)) != -1) {
            String string = dotClassPathEntry.getRawPath().substring(n + 1);
            return string.startsWith("junit") && string.endsWith(".jar");
        }
        return false;
    }
}

