/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleCheck
extends AbstractHint {
    private volatile transient boolean stop;

    public DoubleCheck() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.SYNCHRONIZED);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        Tree tree = treePath.getLeaf();
        if (tree == null || tree.getKind() != Tree.Kind.SYNCHRONIZED) {
            return null;
        }
        SynchronizedTree synchronizedTree = (SynchronizedTree)tree;
        IfTree ifTree = this.findOuterIf(compilationInfo, treePath);
        if (ifTree == null) {
            return null;
        }
        IfTree ifTree2 = null;
        for (StatementTree object2 : synchronizedTree.getBlock().getStatements()) {
            if (this.sameIf(object2, ifTree)) {
                ifTree2 = (IfTree)object2;
                break;
            }
            if (!this.stop) continue;
            return null;
        }
        if (ifTree2 == null) {
            return null;
        }
        TreePath treePath2 = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), ifTree);
        List<FixImpl> list = Collections.singletonList(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), synchronizedTree);
        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(DoubleCheck.class, (String)"MSG_FixDoubleCheck"), list, (FileObject)compilationInfo.getFileObject(), (int)n, (int)(n + "synchronized".length()));
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_DoubleCheck");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_DoubleCheck");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private IfTree findOuterIf(CompilationInfo compilationInfo, TreePath treePath) {
        while (!this.stop && (treePath = treePath.getParentPath()) != null) {
            BlockTree blockTree;
            Tree tree = treePath.getLeaf();
            if (tree.getKind() == Tree.Kind.IF) {
                return (IfTree)tree;
            }
            if (tree.getKind() == Tree.Kind.BLOCK && (blockTree = (BlockTree)tree).getStatements().size() == 1) continue;
            return null;
        }
        return null;
    }

    private boolean sameIf(StatementTree statementTree, IfTree ifTree) {
        if (statementTree.getKind() != Tree.Kind.IF) {
            return false;
        }
        IfTree ifTree2 = (IfTree)statementTree;
        if (ifTree2.getElseStatement() != null) {
            return false;
        }
        if (ifTree.getElseStatement() != null) {
            return false;
        }
        ExpressionTree expressionTree = this.equalToNull(ifTree2.getCondition());
        ExpressionTree expressionTree2 = this.equalToNull(ifTree.getCondition());
        if (expressionTree == null || expressionTree2 == null) {
            return false;
        }
        if (expressionTree.getKind() == Tree.Kind.IDENTIFIER && expressionTree2.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree identifierTree = (IdentifierTree)expressionTree;
            IdentifierTree identifierTree2 = (IdentifierTree)expressionTree2;
            return ((Object)identifierTree.getName()).equals(identifierTree2.getName());
        }
        return false;
    }

    private ExpressionTree equalToNull(ExpressionTree expressionTree) {
        ExpressionTree expressionTree2;
        if (expressionTree.getKind() == Tree.Kind.PARENTHESIZED) {
            expressionTree2 = (ParenthesizedTree)expressionTree;
            expressionTree = expressionTree2.getExpression();
        }
        if (expressionTree.getKind() != Tree.Kind.EQUAL_TO) {
            return null;
        }
        expressionTree2 = (BinaryTree)expressionTree;
        if (expressionTree2.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL && expressionTree2.getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return expressionTree2.getRightOperand();
        }
        if (expressionTree2.getLeftOperand().getKind() != Tree.Kind.NULL_LITERAL && expressionTree2.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            return expressionTree2.getLeftOperand();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private TreePathHandle synchHandle;
        private TreePathHandle ifHandle;
        private FileObject file;

        public FixImpl(TreePathHandle treePathHandle, TreePathHandle treePathHandle2, FileObject fileObject) {
            this.synchHandle = treePathHandle;
            this.ifHandle = treePathHandle2;
            this.file = fileObject;
        }

        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_DoubleCheck");
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            modificationResult.commit();
            return null;
        }

        public String toString() {
            return "FixDoubleCheck";
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            Tree tree = this.synchHandle.resolve((CompilationInfo)workingCopy).getLeaf();
            Tree tree2 = this.ifHandle.resolve((CompilationInfo)workingCopy).getLeaf();
            workingCopy.rewrite(tree2, tree);
        }
    }
}

