/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.DoubleCheck;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAccess
extends AbstractHint {
    private static final String SUPPRESS_WARNINGS_KEY = "static-access";
    private volatile transient boolean stop;

    public StaticAccess() {
        super(true, true, AbstractHint.HintSeverity.WARNING, SUPPRESS_WARNINGS_KEY);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.MEMBER_SELECT);
    }

    protected List<Fix> computeFixes(CompilationInfo compilationInfo, TreePath treePath, int[] nArray, int[] nArray2, String[] stringArray) {
        Object object;
        if (treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        MemberSelectTree memberSelectTree = (MemberSelectTree)treePath.getLeaf();
        ExpressionTree expressionTree = memberSelectTree.getExpression();
        TreePath treePath2 = new TreePath(treePath, expressionTree);
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath2);
        if (typeMirror == null) {
            return null;
        }
        Element element = compilationInfo.getTypes().asElement(typeMirror);
        if (element == null || element.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element;
        if (this.isError(typeElement)) {
            return null;
        }
        Name name = null;
        if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
            object = (MemberSelectTree)expressionTree;
            name = object.getIdentifier();
        }
        if (expressionTree.getKind() == Tree.Kind.IDENTIFIER) {
            object = (IdentifierTree)expressionTree;
            name = object.getName();
        }
        if (name != null) {
            if (((Object)name).equals(typeElement.getSimpleName())) {
                return null;
            }
            if (((Object)name).equals(typeElement.getQualifiedName())) {
                return null;
            }
        }
        if ((object = compilationInfo.getTrees().getElement(treePath)) == null || !object.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (this.isError((Element)object)) {
            return null;
        }
        int[] nArray3 = new int[]{(int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), expressionTree), (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), expressionTree)};
        if (nArray3[0] == -1 || nArray3[1] == -1) {
            return null;
        }
        nArray2[0] = object.getKind().isField() ? 0 : (object.getKind() == ElementKind.METHOD ? 1 : 2);
        stringArray[0] = object.getSimpleName().toString();
        ArrayList<Fix> arrayList = new ArrayList<Fix>(2);
        arrayList.add(new FixImpl(TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo), TreePathHandle.create((Element)typeElement, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
        arrayList.add(FixFactory.createSuppressWarnings(compilationInfo, treePath, SUPPRESS_WARNINGS_KEY));
        nArray[0] = nArray3[0];
        nArray[1] = nArray3[1];
        return arrayList;
    }

    private boolean isError(Element element) {
        if (element == null) {
            return true;
        }
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeMirror typeMirror = ((TypeElement)element).asType();
        return typeMirror == null || typeMirror.getKind() == TypeKind.ERROR;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        int[] nArray = new int[2];
        int[] nArray2 = new int[1];
        String[] stringArray = new String[1];
        List<Fix> list = this.computeFixes(compilationInfo, treePath, nArray, nArray2, stringArray);
        if (list == null) {
            return null;
        }
        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(StaticAccess.class, (String)"MSG_StaticAccess", (Object)nArray2[0], (Object)stringArray[0]), list, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_StaticAccessName");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_StaticAccess");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private final TreePathHandle expr;
        private final TreePathHandle type;
        private final FileObject file;

        public FixImpl(TreePathHandle treePathHandle, TreePathHandle treePathHandle2, FileObject fileObject) {
            this.file = fileObject;
            this.type = treePathHandle2;
            this.expr = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_StaticAccessText");
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            modificationResult.commit();
            return null;
        }

        public String toString() {
            return "FixStaticAccess";
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TreePath treePath = this.expr.resolve((CompilationInfo)workingCopy);
            Element element = this.type.resolveElement((CompilationInfo)workingCopy);
            ExpressionTree expressionTree = workingCopy.getTreeMaker().QualIdent(element);
            workingCopy.rewrite(treePath.getLeaf(), (Tree)expressionTree);
        }
    }
}

