/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java6Methods {
    private static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");

    private Java6Methods() {
    }

    public static boolean isJDK6() {
        return IS_JDK_16;
    }

    public static long[] instanceCounts(VirtualMachine virtualMachine, List<ReferenceType> list) {
        try {
            Method method = VirtualMachine.class.getMethod("instanceCounts", List.class);
            Object object = method.invoke((Object)virtualMachine, list);
            return (long[])object;
        }
        catch (Exception exception) {
            Logger.getLogger(Java6Methods.class.getName()).log(Level.INFO, "", exception);
            return new long[list.size()];
        }
    }

    public static List<ObjectReference> instances(ReferenceType referenceType, long l) {
        try {
            Method method = ReferenceType.class.getMethod("instances", Long.TYPE);
            Object object = method.invoke((Object)referenceType, l);
            return (List)object;
        }
        catch (Exception exception) {
            Logger.getLogger(Java6Methods.class.getName()).log(Level.INFO, "", exception);
            return new ArrayList<ObjectReference>();
        }
    }

    public static List<ObjectReference> referringObjects(ObjectReference objectReference, long l) {
        try {
            Method method = ObjectReference.class.getMethod("referringObjects", Long.TYPE);
            Object object = method.invoke((Object)objectReference, l);
            return (List)object;
        }
        catch (Exception exception) {
            Logger.getLogger(Java6Methods.class.getName()).log(Level.INFO, "", exception);
            return new ArrayList<ObjectReference>();
        }
    }

    public static boolean canRequestMonitorEvents(VirtualMachine virtualMachine) {
        try {
            Method method = VirtualMachine.class.getMethod("canRequestMonitorEvents", new Class[0]);
            Boolean bl = (Boolean)method.invoke((Object)virtualMachine, new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            Logger.getLogger(Java6Methods.class.getName()).log(Level.INFO, "", exception);
            return false;
        }
    }

    public static EventRequest createMonitorContendedEnteredRequest(EventRequestManager eventRequestManager) {
        try {
            Method method = EventRequestManager.class.getMethod("createMonitorContendedEnteredRequest", new Class[0]);
            EventRequest eventRequest = (EventRequest)method.invoke((Object)eventRequestManager, new Object[0]);
            return eventRequest;
        }
        catch (Exception exception) {
            Logger.getLogger(Java6Methods.class.getName()).log(Level.INFO, "", exception);
            return null;
        }
    }

    public static void addThreadFilter2MonitorContendedEnteredRequest(EventRequest eventRequest, ThreadReference threadReference) {
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("com.sun.jdi.request.MonitorContendedEnteredRequest");
            Method method = clazz.getMethod("addThreadFilter", ThreadReference.class);
            method.invoke((Object)eventRequest, threadReference);
        }
        catch (Exception exception) {
            Logger.getLogger(Java6Methods.class.getName()).log(Level.INFO, "", exception);
        }
    }
}

