/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepIntoActionProvider;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StepActionProvider
extends JPDADebuggerActionProvider
implements Executor {
    private StepRequest stepRequest;
    private ContextProvider lookupProvider;
    private JPDAStepImpl.MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private boolean smartSteppingStepOut;
    private static boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private StepIntoActionProvider stepIntoActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    private static int getJDIAction(Object object) {
        if (object == ActionsManager.ACTION_STEP_OUT) {
            return 3;
        }
        if (object == ActionsManager.ACTION_STEP_OVER) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public StepActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.lookupProvider = contextProvider;
        this.setProviderToDisableOnLazyAction(this);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingStepOut = map.containsKey("SS_ACTION_STEPOUT");
        }
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER));
    }

    public void doAction(Object object) {
        this.runAction(object);
    }

    public void postAction(final Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepActionProvider.this.runAction(object);
                    Object var2_1 = null;
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    runnable.run();
                    throw throwable;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object object) {
        Object object2 = this.getDebuggerImpl().LOCK;
        synchronized (object2) {
            try {
                JPDAThreadImpl jPDAThreadImpl;
                int n = this.getDebuggerImpl().getSuspend();
                JPDAThreadImpl jPDAThreadImpl2 = jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
                synchronized (jPDAThreadImpl2) {
                    jPDAThreadImpl.waitUntilMethodInvokeDone();
                    ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                    this.removeStepRequests(threadReference);
                    VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
                    if (virtualMachine == null) {
                        return;
                    }
                    this.stepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, StepActionProvider.getJDIAction(object));
                    this.stepRequest.addCountFilter(1);
                    this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                    this.stepRequest.setSuspendPolicy(n);
                    try {
                        this.stepRequest.enable();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        logger.warning(illegalThreadStateException.getLocalizedMessage() + "\nThread: " + threadReference.name() + ", suspended = " + threadReference.isSuspended() + ", suspend count = " + threadReference.suspendCount() + ", status = " + threadReference.status());
                        this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                        return;
                    }
                    logger.fine("JDI Request (action " + object + "): " + this.stepRequest);
                    if (object == ActionsManager.ACTION_STEP_OUT) {
                        this.addMethodExitBP(threadReference, jPDAThreadImpl);
                    }
                    jPDAThreadImpl.disableMethodInvokeUntilResumed();
                }
                jPDAThreadImpl.setInStep(true, this.stepRequest);
                if (n == 1) {
                    this.getDebuggerImpl().resumeCurrentThread();
                } else {
                    this.getDebuggerImpl().resume();
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                ErrorManager.getDefault().notify(256, ErrorManager.getDefault().annotate((Throwable)vMDisconnectedException, NbBundle.getMessage(StepActionProvider.class, (String)"VMDisconnected")));
            }
        }
    }

    private void addMethodExitBP(ThreadReference threadReference, JPDAThread jPDAThread) {
        Location location;
        if (!MethodBreakpointImpl.canGetMethodReturnValues(threadReference.virtualMachine())) {
            return;
        }
        try {
            location = threadReference.frame(0).location();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            logger.fine("Incompatible Thread State: " + incompatibleThreadStateException.getLocalizedMessage());
            return;
        }
        String string = location.declaringType().name();
        String string2 = location.method().name();
        MethodBreakpoint methodBreakpoint = MethodBreakpoint.create((String)string, (String)string2);
        methodBreakpoint.setBreakpointType(2);
        methodBreakpoint.setHidden(true);
        methodBreakpoint.setSuspend(0);
        methodBreakpoint.setThreadFilters((JPDADebugger)this.getDebuggerImpl(), new JPDAThread[]{jPDAThread});
        this.lastMethodExitBreakpointListener = new JPDAStepImpl.MethodExitBreakpointListener(methodBreakpoint);
        methodBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)methodBreakpoint);
    }

    protected void checkEnabled(int n) {
        for (Object e : this.getActions()) {
            this.getDebuggerImpl();
            this.setEnabled(e, n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(Event event) {
        StepRequest stepRequest = (StepRequest)event.request();
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getThread(stepRequest.thread());
        jPDAThreadImpl.setInStep(false, null);
        LocatableEvent locatableEvent = (LocatableEvent)event;
        String string = locatableEvent.location().declaringType().name();
        ThreadReference threadReference = locatableEvent.thread();
        this.setLastOperation(threadReference);
        this.removeStepRequests(threadReference);
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            block14: {
                int n = this.getDebuggerImpl().getSuspend();
                try {
                    if (!threadReference.frame(0).location().method().isSynthetic()) break block14;
                    int n2 = ((StepRequest)event.request()).depth();
                    VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
                    if (virtualMachine == null) {
                        return false;
                    }
                    this.stepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, n2);
                    this.stepRequest.addCountFilter(1);
                    this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                    this.stepRequest.setSuspendPolicy(n);
                    try {
                        this.stepRequest.enable();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                        this.stepRequest = null;
                    }
                    return true;
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    logger.fine("Incompatible Thread State: " + incompatibleThreadStateException.getLocalizedMessage());
                }
            }
            boolean bl = this.getSmartSteppingFilterImpl().stopHere(string);
            if (ssverbose) {
                System.out.println("SS  SmartSteppingFilter.stopHere (" + string + ") ? " + bl);
            }
            if (bl) {
                JPDAThread jPDAThread = this.getDebuggerImpl().getThread(threadReference);
                if (this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, jPDAThread, this.getSmartSteppingFilterImpl())) {
                    return false;
                }
            }
            if (ssverbose) {
                System.out.println("\nSS:  SMART STEPPING START! ********** ");
            }
            if (this.smartSteppingStepOut) {
                this.getStepIntoActionProvider().doAction(ActionsManager.ACTION_STEP_OUT);
            } else {
                this.getStepIntoActionProvider().doAction("smartStepInto");
            }
            return true;
        }
    }

    public void removed(EventRequest eventRequest) {
        StepRequest stepRequest = (StepRequest)eventRequest;
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getThread(stepRequest.thread());
        jPDAThreadImpl.setInStep(false, null);
        if (this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    private void setLastOperation(ThreadReference threadReference) {
        Location location;
        Variable variable = null;
        if (this.lastMethodExitBreakpointListener != null) {
            variable = this.lastMethodExitBreakpointListener.getReturnValue();
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
        try {
            location = threadReference.frame(0).location();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            logger.fine("Incompatible Thread State: " + incompatibleThreadStateException.getLocalizedMessage());
            return;
        }
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string = session == null ? null : session.getCurrentLanguage();
        SourcePath sourcePath = this.getDebuggerImpl().getEngineContext();
        String string2 = sourcePath.getURL(location, string);
        ExpressionPool expressionPool = this.getDebuggerImpl().getExpressionPool();
        ExpressionPool.Expression expression = expressionPool.getExpressionAt(location, string2);
        if (expression == null) {
            return;
        }
        EditorContext.Operation[] operationArray = expression.getOperations();
        int n = (int)location.codeIndex();
        byte[] byArray = location.method().bytecodes();
        n = n >= 5 && (byArray[n - 5] & 0xFF) == 185 ? (n -= 5) : (n -= 3);
        int n2 = expression.findNextOperationIndex(n - 1);
        if (n2 < 0 || operationArray[n2].getBytecodeIndex() != n) {
            return;
        }
        EditorContext.Operation operation = operationArray[n2];
        operation.setReturnValue(variable);
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getThread(threadReference);
        jPDAThreadImpl.addLastOperation(operation);
        jPDAThreadImpl.setCurrentOperation(operation);
    }

    private StepIntoActionProvider getStepIntoActionProvider() {
        if (this.stepIntoActionProvider == null) {
            List list = this.lookupProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepIntoActionProvider)) continue;
                this.stepIntoActionProvider = (StepIntoActionProvider)list.get(i);
            }
        }
        return this.stepIntoActionProvider;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }
}

