/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.ThreadInfoPanel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class BreakpointImpl
implements Executor,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private JPDABreakpoint breakpoint;
    private BreakpointsReader reader;
    private Expression compiledCondition;
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private int hitCountFilter = 0;

    protected BreakpointImpl(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        this.debugger = jPDADebuggerImpl;
        this.reader = breakpointsReader;
        this.breakpoint = jPDABreakpoint;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.breakpoint.isEnabled() && this.isEnabled()) {
            this.setRequests();
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    protected final void setValidity(Breakpoint.VALIDITY vALIDITY, String string) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)this.breakpoint).stateChanged(new ValidityChangeEvent(vALIDITY, string));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("disposed".equals(string)) {
            this.remove();
        } else if (!"validity".equals(string) && !"groupName".equals(string)) {
            if (this.reader != null) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BreakpointImpl.this.update();
                }
            });
        }
    }

    protected abstract void setRequests();

    protected void remove() {
        this.removeAllEventRequests();
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            throw new VMDisconnectedException();
        }
        return virtualMachine.eventRequestManager();
    }

    protected void addEventRequest(EventRequest eventRequest) {
        this.addEventRequest(eventRequest, false);
    }

    protected synchronized void addEventRequest(EventRequest eventRequest, boolean bl) {
        block8: {
            block7: {
                logger.fine("BreakpointImpl addEventRequest: " + eventRequest);
                this.requests.add(eventRequest);
                this.getDebugger().getOperator().register(eventRequest, this);
                if (this.getBreakpoint().getSuspend() == 2) {
                    eventRequest.setSuspendPolicy(2);
                } else {
                    eventRequest.setSuspendPolicy(1);
                }
                int n = this.getBreakpoint().getHitCountFilter();
                if (bl || n <= 0) break block7;
                eventRequest.addCountFilter(n);
                switch (this.getBreakpoint().getHitCountFilteringStyle()) {
                    case MULTIPLE: {
                        this.hitCountFilter = n;
                        break block8;
                    }
                    case EQUAL: {
                        this.hitCountFilter = 0;
                        break block8;
                    }
                    case GREATER: {
                        this.hitCountFilter = -1;
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
                    }
                }
            }
            this.hitCountFilter = 0;
        }
        eventRequest.enable();
    }

    private synchronized void removeAllEventRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        VirtualMachine virtualMachine = this.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        int n = this.requests.size();
        try {
            for (int i = 0; i < n; ++i) {
                EventRequest eventRequest = this.requests.get(i);
                logger.fine("BreakpointImpl removeEventRequest: " + eventRequest);
                virtualMachine.eventRequestManager().deleteEventRequest(eventRequest);
                this.getDebugger().getOperator().unregister(eventRequest);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        this.requests = new LinkedList<EventRequest>();
    }

    private synchronized void removeEventRequest(EventRequest eventRequest) {
        VirtualMachine virtualMachine = this.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        try {
            logger.fine("BreakpointImpl removeEventRequest: " + eventRequest);
            virtualMachine.eventRequestManager().deleteEventRequest(eventRequest);
            this.getDebugger().getOperator().unregister(eventRequest);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        this.requests.remove(eventRequest);
    }

    protected abstract EventRequest createEventRequest(EventRequest var1);

    protected boolean perform(Event event, String string, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        boolean bl;
        Object object;
        if (this.hitCountFilter > 0) {
            event.request().disable();
            event.request().enable();
        }
        if (this.hitCountFilter == -1) {
            event.request().disable();
            this.removeEventRequest(event.request());
            this.addEventRequest(this.createEventRequest(event.request()), true);
        }
        try {
            this.getDebugger().setAltCSF(threadReference.frame(0));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = "Thread '" + threadReference.name() + "': status = " + threadReference.status() + ", is suspended = " + threadReference.isSuspended() + ", suspend count = " + threadReference.suspendCount() + ", is at breakpoint = " + threadReference.isAtBreakpoint();
            Logger.getLogger(BreakpointImpl.class.getName()).log(Level.INFO, (String)object, incompatibleThreadStateException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Variable variable = null;
        if (this.getBreakpoint() instanceof MethodBreakpoint && (((MethodBreakpoint)this.getBreakpoint()).getBreakpointType() & 2) != 0) {
            object = (JPDAThreadImpl)this.getDebugger().getThread(threadReference);
            if (value != null) {
                ReturnVariableImpl returnVariableImpl = new ReturnVariableImpl(this.getDebugger(), value, "", ((JPDAThreadImpl)object).getMethodName());
                ((JPDAThreadImpl)object).setReturnVariable(returnVariableImpl);
                variable = returnVariableImpl;
            }
        }
        if (variable == null) {
            variable = this.debugger.getVariable(value);
        }
        if (string == null || string.equals("")) {
            object = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, 0, this.debugger.getThread(threadReference), referenceType, variable);
            this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), (JPDABreakpointEvent)object);
            bl = this.getBreakpoint().getSuspend() == 0 || object.getResume();
            logger.fine("BreakpointImpl: perform breakpoint (no condition): " + this + " resume: " + bl);
        } else {
            bl = this.evaluateCondition(string, threadReference, referenceType, variable);
            bl = this.getBreakpoint().getSuspend() == 0 || bl;
        }
        this.getDebugger().setAltCSF(null);
        if (!bl) {
            bl = this.checkWhetherResumeToFinishStep(threadReference);
        }
        if (!bl) {
            ((JPDAThreadImpl)this.getDebugger().getThread(threadReference)).setCurrentBreakpoint(this.breakpoint);
        }
        return bl;
    }

    private boolean checkWhetherResumeToFinishStep(ThreadReference threadReference) {
        int n;
        List<StepRequest> list = threadReference.virtualMachine().eventRequestManager().stepRequests();
        if (list.size() > 0 && ((n = this.breakpoint.getSuspend()) == 2 || n == 1)) {
            ThreadInfoPanel[] threadInfoPanelArray;
            Object object;
            boolean bl = false;
            ArrayList<StepRequest> arrayList = new ArrayList<StepRequest>(list);
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (StepRequest)arrayList.get(i);
                threadInfoPanelArray = object.thread();
                if (!object.isEnabled()) {
                    arrayList.remove(i);
                    continue;
                }
                if (object.thread().status() == 0) {
                    threadReference.virtualMachine().eventRequestManager().deleteEventRequest((EventRequest)object);
                    this.debugger.getOperator().unregister((EventRequest)object);
                    arrayList.remove(i);
                    continue;
                }
                if (!threadReference.equals(threadInfoPanelArray)) continue;
                bl = true;
            }
            if (bl) {
                return false;
            }
            if (arrayList.size() > 0 && (bl || n == 2)) {
                Boolean bl2 = this.debugger.getStepInterruptByBptResumeDecision();
                if (bl2 != null) {
                    return bl2;
                }
                object = bl ? NbBundle.getMessage(BreakpointImpl.class, (String)"MSG_StepThreadInterruptedByBR", (Object)this.breakpoint.toString()) : NbBundle.getMessage(BreakpointImpl.class, (String)"MSG_StepInterruptedByBR", (Object)this.breakpoint.toString(), (Object)threadReference.name(), (Object)((StepRequest)arrayList.get(0)).thread().name());
                threadInfoPanelArray = new ThreadInfoPanel[]{null};
                try {
                    SwingUtilities.invokeAndWait(new Runnable((String)object){
                        final /* synthetic */ String val$message;
                        {
                            this.val$message = string;
                        }

                        public void run() {
                            threadInfoPanelArray[0] = ThreadInfoPanel.create(this.val$message, NbBundle.getMessage(BreakpointImpl.class, (String)"StepInterruptedByBR_Btn1"), NbBundle.getMessage(BreakpointImpl.class, (String)"StepInterruptedByBR_Btn1_TIP"), NbBundle.getMessage(BreakpointImpl.class, (String)"StepInterruptedByBR_Btn2"), NbBundle.getMessage(BreakpointImpl.class, (String)"StepInterruptedByBR_Btn2_TIP"));
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                if (threadInfoPanelArray[0] == null) {
                    return false;
                }
                threadInfoPanelArray[0].setButtonListener(new ThreadInfoPanel.ButtonListener(){

                    public void buttonPressed(int n) {
                        if (n == 2) {
                            BreakpointImpl.this.debugger.setStepInterruptByBptResumeDecision(Boolean.TRUE);
                        }
                        BreakpointImpl.this.debugger.resume();
                    }
                });
                this.debugger.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        block2: {
                            block3: {
                                String string = propertyChangeEvent.getPropertyName();
                                BreakpointImpl.this.debugger;
                                if (!string.equals("state")) break block2;
                                Object object = propertyChangeEvent.getNewValue();
                                BreakpointImpl.this.debugger;
                                if (object.equals(2)) break block3;
                                Object object2 = propertyChangeEvent.getNewValue();
                                BreakpointImpl.this.debugger;
                                if (!object2.equals(4)) break block2;
                            }
                            BreakpointImpl.this.debugger.removePropertyChangeListener(this);
                            threadInfoPanelArray[0].dismiss();
                        }
                    }
                });
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(String string, ThreadReference threadReference, ReferenceType referenceType, Variable variable) {
        try {
            try {
                JPDABreakpointEvent jPDABreakpointEvent;
                boolean bl;
                Object object = this.debugger.LOCK;
                synchronized (object) {
                    StackFrame stackFrame = threadReference.frame(0);
                    bl = this.evaluateConditionIn(string, stackFrame, 0);
                    jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, bl ? 1 : 2, this.debugger.getThread(threadReference), referenceType, variable);
                }
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
                logger.fine("BreakpointImpl: perform breakpoint (condition = " + bl + "): " + this + " resume: " + (!bl || jPDABreakpointEvent.getResume()));
                return !bl || jPDABreakpointEvent.getResume();
            }
            catch (ParseException parseException) {
                JPDABreakpointEvent jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, (Throwable)parseException, this.debugger.getThread(threadReference), referenceType, variable);
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
                logger.fine("BreakpointImpl: perform breakpoint (bad condition): " + this + " resume: " + jPDABreakpointEvent.getResume());
                return jPDABreakpointEvent.getResume();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                JPDABreakpointEvent jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, (Throwable)invalidExpressionException, this.debugger.getThread(threadReference), referenceType, variable);
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
                logger.fine("BreakpointImpl: perform breakpoint (invalid condition): " + this + " resume: " + jPDABreakpointEvent.getResume());
                return jPDABreakpointEvent.getResume();
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            incompatibleThreadStateException.printStackTrace();
            return false;
        }
    }

    private boolean evaluateConditionIn(String string, StackFrame stackFrame, int n) throws ParseException, InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(string)) {
            this.compiledCondition = Expression.parse(string, "1.5.0");
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, stackFrame, n);
        try {
            return ((BooleanValue)value).booleanValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidExpressionException((Throwable)classCastException);
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidExpressionException((Throwable)nullPointerException);
        }
    }

    static boolean match(String string, String string2) {
        if (string2.startsWith("*")) {
            return string.endsWith(string2.substring(1));
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string.equals(string2);
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY vALIDITY, String string) {
            super(vALIDITY);
            this.reason = string;
        }

        public String toString() {
            return this.reason;
        }
    }
}

