/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.util.Exceptions;

public class InvocationExceptionTranslated
extends ApplicationException {
    private ObjectReference exeption;
    private JPDADebuggerImpl debugger;
    private String invocationMessage;
    private String message;
    private String localizedMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;

    public InvocationExceptionTranslated(InvocationException invocationException, JPDADebuggerImpl jPDADebuggerImpl) {
        this(invocationException.getMessage(), invocationException.exception(), jPDADebuggerImpl);
    }

    private InvocationExceptionTranslated(String string, ObjectReference objectReference, JPDADebuggerImpl jPDADebuggerImpl) {
        super(InvocationException.class.getName(), null);
        this.invocationMessage = string;
        this.exeption = objectReference;
        this.debugger = jPDADebuggerImpl;
    }

    public synchronized String getMessage() {
        if (this.message == null) {
            Method method = ((ClassType)this.exeption.type()).concreteMethodByName("getMessage", "()Ljava/lang/String;");
            try {
                StringReference stringReference = (StringReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                this.message = stringReference != null ? stringReference.value() : "";
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Exceptions.printStackTrace((Throwable)invalidExpressionException);
                this.message = "";
            }
        }
        if (this.invocationMessage != null) {
            return this.invocationMessage + ": " + this.message;
        }
        return this.message;
    }

    public String getLocalizedMessage() {
        if (this.localizedMessage == null) {
            Method method = ((ClassType)this.exeption.type()).concreteMethodByName("getLocalizedMessage", "()Ljava/lang/String;");
            try {
                StringReference stringReference = (StringReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                this.localizedMessage = stringReference == null ? "" : stringReference.value();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Exceptions.printStackTrace((Throwable)invalidExpressionException);
                this.localizedMessage = "";
            }
        }
        if (this.invocationMessage != null) {
            return this.invocationMessage + ": " + this.localizedMessage;
        }
        return this.localizedMessage;
    }

    private String getOriginalLocalizedMessage() {
        this.getLocalizedMessage();
        return this.localizedMessage;
    }

    public synchronized Throwable getCause() {
        if (this.cause == null) {
            Method method = ((ClassType)this.exeption.type()).concreteMethodByName("getCause", "()Ljava/lang/Throwable;");
            try {
                ObjectReference objectReference = (ObjectReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                this.cause = objectReference != null ? new InvocationExceptionTranslated(null, objectReference, this.debugger) : this;
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Exceptions.printStackTrace((Throwable)invalidExpressionException);
                this.cause = this;
            }
        }
        return this.cause == this ? null : this.cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println((Object)this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printStream.println("\tat " + stackTraceElementArray[i]);
            }
            InvocationExceptionTranslated invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause());
            if (invocationExceptionTranslated != null) {
                invocationExceptionTranslated.printStackTraceAsCause(printStream, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        InvocationExceptionTranslated invocationExceptionTranslated;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + (Object)((Object)this));
        for (int i = 0; i <= n; ++i) {
            printStream.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printStream.println("\t... " + n2 + " more");
        }
        if ((invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause())) != null) {
            invocationExceptionTranslated.printStackTraceAsCause(printStream, stackTraceElementArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println((Object)this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printWriter.println("\tat " + stackTraceElementArray[i]);
            }
            InvocationExceptionTranslated invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause());
            if (invocationExceptionTranslated != null) {
                invocationExceptionTranslated.printStackTraceAsCause(printWriter, stackTraceElementArray);
            }
        }
    }

    private void printStackTraceAsCause(PrintWriter printWriter, StackTraceElement[] stackTraceElementArray) {
        InvocationExceptionTranslated invocationExceptionTranslated;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printWriter.println("Caused by: " + (Object)((Object)this));
        for (int i = 0; i <= n; ++i) {
            printWriter.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printWriter.println("\t... " + n2 + " more");
        }
        if ((invocationExceptionTranslated = (InvocationExceptionTranslated)((Object)this.getCause())) != null) {
            invocationExceptionTranslated.printStackTraceAsCause(printWriter, stackTraceElementArray2);
        }
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            Method method = ((ClassType)this.exeption.type()).concreteMethodByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
            try {
                ArrayReference arrayReference = (ArrayReference)this.debugger.invokeMethod(this.exeption, method, new Value[0]);
                int n = arrayReference.length();
                this.stackTrace = new StackTraceElement[n];
                for (int i = 0; i < n; ++i) {
                    this.stackTrace[i] = this.getStackTraceElement((ObjectReference)arrayReference.getValue(i));
                }
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Exceptions.printStackTrace((Throwable)invalidExpressionException);
                this.stackTrace = new StackTraceElement[0];
            }
        }
        return this.stackTrace;
    }

    private StackTraceElement getStackTraceElement(ObjectReference objectReference) {
        int n;
        String string;
        String string2;
        String string3;
        Value value;
        Method method = ((ClassType)objectReference.type()).concreteMethodByName("getClassName", "()Ljava/lang/String;");
        try {
            value = (StringReference)this.debugger.invokeMethod(objectReference, method, new Value[0]);
            string3 = value.value();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            Exceptions.printStackTrace((Throwable)invalidExpressionException);
            string3 = "";
        }
        method = ((ClassType)objectReference.type()).concreteMethodByName("getMethodName", "()Ljava/lang/String;");
        try {
            value = (StringReference)this.debugger.invokeMethod(objectReference, method, new Value[0]);
            string2 = value.value();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            Exceptions.printStackTrace((Throwable)invalidExpressionException);
            string2 = "";
        }
        method = ((ClassType)objectReference.type()).concreteMethodByName("getFileName", "()Ljava/lang/String;");
        try {
            value = (StringReference)this.debugger.invokeMethod(objectReference, method, new Value[0]);
            string = value.value();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            Exceptions.printStackTrace((Throwable)invalidExpressionException);
            string = "";
        }
        method = ((ClassType)objectReference.type()).concreteMethodByName("getLineNumber", "()I");
        try {
            value = (IntegerValue)this.debugger.invokeMethod(objectReference, method, new Value[0]);
            n = value.value();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            Exceptions.printStackTrace((Throwable)invalidExpressionException);
            n = 0;
        }
        return new StackTraceElement(string3, string2, string, n);
    }

    public String toString() {
        String string = this.exeption.type().name();
        String string2 = this.getOriginalLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }
}

