/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.javascript.ui.MoveClassUI;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveClassesUI
implements RefactoringUI,
RefactoringUIBypass {
    private List<FileObject> resources;
    private Set<FileObject> javaObjects;
    private MovePanel panel;
    private MoveRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String string) {
        return NbBundle.getMessage(MoveClassUI.class, (String)string);
    }

    public MoveClassesUI(Set<FileObject> set) {
        this(set, null, null);
    }

    public MoveClassesUI(Set<FileObject> set, FileObject fileObject, PasteType pasteType) {
        this.disable = fileObject != null;
        this.targetFolder = fileObject;
        this.javaObjects = set;
        this.pasteType = pasteType;
        if (!this.disable) {
            this.resources = new ArrayList<FileObject>(set);
        }
    }

    public String getName() {
        return MoveClassesUI.getString("LBL_MoveClasses");
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            ClassPath classPath;
            String string = null;
            if (this.targetFolder != null && (classPath = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                string = classPath.getResourceName(this.targetFolder, '.', false);
            }
            this.panel = new MovePanel(changeListener, string != null ? string : MoveClassesUI.getDOPackageName(this.javaObjects.iterator().next().getParent()), MoveClassesUI.getString("LBL_MoveClassesHeadline"));
        }
        return this.panel;
    }

    private static String getDOPackageName(FileObject fileObject) {
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassesUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean bl) {
        if (this.panel == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(uRL.toExternalForm() + URLEncoder.encode(this.panel.getPackageName().replace('.', '/')))));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (bl) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        if (this.refactoring == null) {
            if (this.disable) {
                this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])this.javaObjects.toArray()));
                this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(this.javaObjects.toArray(new FileObject[this.javaObjects.size()])));
            } else {
                this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])this.resources.toArray()));
                this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(this.resources.toArray(new FileObject[this.resources.size()])));
            }
        }
        return this.refactoring;
    }

    private final Vector<Node> getNodes() {
        Vector<Node> vector = new Vector<Node>(this.javaObjects.size());
        Iterator<FileObject> iterator = this.javaObjects.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)iterator.next());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            vector.add(dataObject.getNodeDelegate());
        }
        return vector;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassesUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }

    class MovePanel
    extends MoveClassPanel {
        public MovePanel(ChangeListener changeListener, String string, String string2) {
            super(changeListener, string, string2, MoveClassesUI.this.targetFolder != null ? MoveClassesUI.this.targetFolder : (FileObject)MoveClassesUI.this.javaObjects.iterator().next());
            this.setCombosEnabled(!MoveClassesUI.this.disable);
            JList jList = new JList(MoveClassesUI.this.getNodes());
            jList.setCellRenderer(new NodeRenderer());
            jList.setVisibleRowCount(5);
            JScrollPane jScrollPane = new JScrollPane(jList);
            this.bottomPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
            this.bottomPanel.setLayout(new BorderLayout());
            this.bottomPanel.add((Component)jScrollPane, "Center");
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(MoveClassesUI.class, (String)"LBL_ListOfClasses"));
            this.bottomPanel.add((Component)jLabel, "North");
        }
    }
}

