/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.spi.MetadataFactory;
import org.netbeans.modules.db.metadata.model.spi.TableImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCTable
implements TableImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCTable.class.getName());
    private final JDBCSchema schema;
    private final String name;
    private Map<String, Column> columns;

    public JDBCTable(JDBCSchema jDBCSchema, String string) {
        this.schema = jDBCSchema;
        this.name = string;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Collection<Column> getColumns() {
        return this.initColumns().values();
    }

    @Override
    public final Column getColumn(String string) {
        return MetadataUtilities.find(string, this.initColumns());
    }

    public String toString() {
        return "JDBCTable[name='" + this.name + "']";
    }

    protected JDBCColumn createColumn(String string) {
        return new JDBCColumn(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createColumns() {
        LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
        try {
            ResultSet resultSet = this.schema.getCatalog().getMetadata().getDmd().getColumns(this.schema.getCatalog().getName(), this.schema.getName(), this.name, "%");
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("COLUMN_NAME");
                    Column column = MetadataFactory.createColumn(new JDBCColumn(string));
                    linkedHashMap.put(string, column);
                    LOGGER.log(Level.FINE, "Created column {0}", column);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.columns = Collections.unmodifiableMap(linkedHashMap);
    }

    private Map<String, Column> initColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        LOGGER.log(Level.FINE, "Initializing columns in {0}", this);
        this.createColumns();
        return this.columns;
    }

    public final void refresh() {
        this.columns = null;
    }
}

