/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.openide.util.RequestProcessor;

public class CurrentProcessInstanceListener
extends DebuggerManagerAdapter {
    private transient Object myLock = new Object();
    private DebuggerEngine engine;
    private BpelDebugger debugger;
    private SourcePath sourcePath;

    public CurrentProcessInstanceListener() {
        boolean bl = true;
    }

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentEngine".equals(propertyChangeEvent.getPropertyName())) {
            this.updateCurrentDebugger();
        } else if ("currentProcessInstance".equals(propertyChangeEvent.getPropertyName())) {
            this.updateCurrentOpenFile();
        }
    }

    private void updateCurrentDebugger() {
        this.engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (this.engine == null) {
            return;
        }
        this.debugger = (BpelDebugger)this.engine.lookupFirst(null, BpelDebugger.class);
        if (this.debugger == null) {
            return;
        }
        this.debugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.sourcePath = (SourcePath)this.engine.lookupFirst(null, SourcePath.class);
        if (this.sourcePath == null) {
            return;
        }
    }

    private void updateCurrentOpenFile() {
        if (this.engine == null || this.debugger == null || this.sourcePath == null) {
            return;
        }
        ProcessInstance processInstance = this.debugger.getCurrentProcessInstance();
        if (processInstance == null) {
            return;
        }
        final String string = this.sourcePath.getSourcePath(processInstance.getProcess().getQName());
        if (string == null) {
            return;
        }
        PemEntity pemEntity = processInstance.getProcessExecutionModel().getLastStartedEntity();
        final String string2 = pemEntity == null ? "/bpws:process[1]" : pemEntity.getPsmEntity().getXpath();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CurrentProcessInstanceListener.this.myLock;
                synchronized (object) {
                    EditorContextBridge.showSource((String)string, (String)string2, null);
                }
            }
        });
    }
}

