/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.bpel.debugger.api.AnnotationType;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelBreakpointListener
extends DebuggerManagerAdapter {
    private Map<LineBreakpoint, Object> myBreakpointToAnnotation = new HashMap<LineBreakpoint, Object>();
    private Map<Object, LineBreakpoint> myAnnotationToBreakpoint = new HashMap<Object, LineBreakpoint>();
    private final AnnotationListener myAnnotationListener = new AnnotationListener();

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            lineBreakpoint.addPropertyChangeListener("enabled", (PropertyChangeListener)((Object)this));
            this.addAnnotation(lineBreakpoint);
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            lineBreakpoint.removePropertyChangeListener("enabled", (PropertyChangeListener)((Object)this));
            this.removeAnnotation(lineBreakpoint);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            this.addAnnotation((LineBreakpoint)propertyChangeEvent.getSource());
        }
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public synchronized List<LineBreakpoint> getBreakpoints() {
        return new ArrayList<LineBreakpoint>(this.myBreakpointToAnnotation.keySet());
    }

    public synchronized LineBreakpoint findBreakpoint(String string, String string2, int n) {
        String string3 = string.replace("\\", "/");
        for (LineBreakpoint lineBreakpoint : this.myBreakpointToAnnotation.keySet()) {
            if (!lineBreakpoint.getURL().equals(string3)) continue;
            Object object = this.myBreakpointToAnnotation.get(lineBreakpoint);
            String string4 = EditorContextBridge.getXpath((Object)object);
            int n2 = EditorContextBridge.getLineNumber((Object)object);
            if ((string2 == null || !string2.equals(string4)) && n != n2) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public Object findAnnotation(LineBreakpoint lineBreakpoint) {
        return this.myBreakpointToAnnotation.get(lineBreakpoint);
    }

    private synchronized void addAnnotation(LineBreakpoint lineBreakpoint) {
        Object object = this.myBreakpointToAnnotation.get(lineBreakpoint);
        if (object != null) {
            EditorContextBridge.removeAnnotation((Object)object);
        }
        AnnotationType annotationType = lineBreakpoint.getXpath() != null ? (lineBreakpoint.isEnabled() ? AnnotationType.ENABLED_BREAKPOINT : AnnotationType.DISABLED_BREAKPOINT) : AnnotationType.BROKEN_BREAKPOINT;
        object = EditorContextBridge.addAnnotation((String)lineBreakpoint.getURL(), (String)lineBreakpoint.getXpath(), (int)lineBreakpoint.getLineNumber(), (AnnotationType)annotationType);
        if (object == null) {
            return;
        }
        EditorContextBridge.addAnnotationListener((Object)object, (PropertyChangeListener)this.myAnnotationListener);
        this.myBreakpointToAnnotation.put(lineBreakpoint, object);
        this.myAnnotationToBreakpoint.put(object, lineBreakpoint);
    }

    private synchronized void removeAnnotation(LineBreakpoint lineBreakpoint) {
        Object object = this.myBreakpointToAnnotation.remove(lineBreakpoint);
        if (object != null) {
            this.myAnnotationToBreakpoint.remove(object);
            EditorContextBridge.removeAnnotationListener((Object)object, (PropertyChangeListener)this.myAnnotationListener);
            EditorContextBridge.removeAnnotation((Object)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBreakpointByAnnotation(Object object) {
        LineBreakpoint lineBreakpoint = null;
        Object object2 = this;
        synchronized (object2) {
            lineBreakpoint = this.myAnnotationToBreakpoint.get(object);
        }
        if (lineBreakpoint == null) {
            return;
        }
        if (!EditorContextBridge.isValid((Object)object)) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lineBreakpoint);
            return;
        }
        if (EditorContextBridge.isAttached((Object)object)) {
            object2 = EditorContextBridge.getXpath((Object)object);
            int n = EditorContextBridge.getLineNumber((Object)object);
            LineBreakpoint lineBreakpoint2 = this.findBreakpoint(lineBreakpoint.getURL(), (String)object2, n);
            if (lineBreakpoint2 != null && !lineBreakpoint2.equals(lineBreakpoint)) {
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lineBreakpoint);
            } else {
                lineBreakpoint.setXpath((String)object2);
                lineBreakpoint.setLineNumber(n);
                lineBreakpoint.touch();
            }
        }
    }

    private class AnnotationListener
    implements PropertyChangeListener {
        private AnnotationListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BpelBreakpointListener.this.updateBreakpointByAnnotation(propertyChangeEvent.getSource());
        }
    }
}

