/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.api.AnnotationType;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelBreakpoint;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelBreakpointListener;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelBreakpointView;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BpelLineBreakpointView
extends BpelBreakpointView {
    private BpelBreakpointListener myBreakpointListener;
    private LineBreakpoint currentBreakpoint;
    private Vector<ModelListener> listeners = new Vector();

    protected String getName(BpelBreakpoint bpelBreakpoint) throws UnknownTypeException {
        AnnotationType annotationType;
        if (!(bpelBreakpoint instanceof LineBreakpoint)) {
            throw new UnknownTypeException((Object)bpelBreakpoint);
        }
        LineBreakpoint lineBreakpoint = (LineBreakpoint)bpelBreakpoint;
        Object object = this.getBreakpointListener().findAnnotation(lineBreakpoint);
        String string = EditorUtil.getFileName(lineBreakpoint.getURL()) + ": " + lineBreakpoint.getLineNumber();
        if (object != null && (annotationType = EditorContextBridge.getAnnotationType((Object)object)) != null && AnnotationType.BROKEN_BREAKPOINT.equals(annotationType)) {
            string = string + " (broken)";
        }
        if (lineBreakpoint.equals(this.currentBreakpoint)) {
            string = "<html><b>" + string + "</b>";
        }
        return string;
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        AnnotationType annotationType;
        if (!(object instanceof LineBreakpoint)) {
            throw new UnknownTypeException(object);
        }
        LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
        Object object2 = this.getBreakpointListener().findAnnotation(lineBreakpoint);
        if (object2 != null && (annotationType = EditorContextBridge.getAnnotationType((Object)object2)) != null && AnnotationType.BROKEN_BREAKPOINT.equals(annotationType)) {
            return "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint_broken";
        }
        if (lineBreakpoint.equals(this.currentBreakpoint)) {
            return "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
        }
        return "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    }

    public void setCurrentPosition(Position position) {
        Vector vector;
        LineBreakpoint lineBreakpoint = this.currentBreakpoint;
        if (position != null) {
            vector = this.getBreakpointListener().findBreakpoint(ModelUtil.getUrl(position.getProcessQName()), position.getXpath(), position.getLineNumber());
            this.currentBreakpoint = vector;
        } else {
            this.currentBreakpoint = null;
        }
        vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (this.currentBreakpoint != null) {
                ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)this.currentBreakpoint));
            }
            if (lineBreakpoint == null) continue;
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)lineBreakpoint));
        }
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private BpelBreakpointListener getBreakpointListener() {
        if (this.myBreakpointListener == null) {
            this.myBreakpointListener = (BpelBreakpointListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BpelBreakpointListener.class));
        }
        return this.myBreakpointListener;
    }
}

