/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.bpel.core.annotations.AnnotationManagerCookie;
import org.netbeans.modules.bpel.core.annotations.DiagramAnnotation;
import org.netbeans.modules.bpel.debugger.api.AnnotationType;
import org.netbeans.modules.bpel.debugger.ui.editor.BpelAnnotationsObserver;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

class BpelAnnotation {
    public static final String PROP_STATE = "state";
    private final AnnotationType myAnnotationType;
    private final DataObject myDataObject;
    private final String myXpath;
    private final UniqueId myBpelEntityId;
    private final int myLineNumber;
    private State myState;
    private DiagramAnnotation myDiagramAnnotation;
    private LineAnnotation myLineAnnotation;
    private PropertyChangeSupport myPcs;

    public BpelAnnotation(AnnotationType annotationType, DataObject dataObject, String string, int n) {
        this.myAnnotationType = annotationType;
        this.myDataObject = dataObject;
        this.myXpath = string;
        this.myLineNumber = n;
        this.myPcs = new PropertyChangeSupport(this);
        this.myState = State.DETACHED;
        this.myBpelEntityId = string != null ? ModelUtil.getBpelEntityId(this.getBpelModel(), string) : null;
    }

    public synchronized boolean attach() {
        if (this.myState == State.ATTACHED) {
            return false;
        }
        assert (this.myDiagramAnnotation == null);
        assert (this.myLineAnnotation == null);
        this.updateDiagramAnnotation();
        this.updateLineAnnotation();
        this.setState(State.ATTACHED);
        return true;
    }

    public synchronized void detach() {
        if (this.myState == State.DETACHED) {
            return;
        }
        this.removeDiagramAnnotation();
        this.removeLineAnnotation();
        this.setState(State.DETACHED);
    }

    public AnnotationType getType() {
        return this.myAnnotationType;
    }

    public String getXpath() {
        return this.myXpath;
    }

    public UniqueId getBpelEntityId() {
        return this.myBpelEntityId;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public State getState() {
        return this.myState;
    }

    public BpelModel getBpelModel() {
        return EditorUtil.getBpelModel(this.myDataObject);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPcs.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPcs.removePropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.myPcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.myPcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected synchronized void update() {
        if (this.myState == State.DETACHED) {
            return;
        }
        this.updateDiagramAnnotation();
        this.updateLineAnnotation();
        this.firePropertyChange(null, null, null);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.myPcs.firePropertyChange(string, object, object2);
    }

    private void updateDiagramAnnotation() {
        if (!this.myAnnotationType.isForDiagram() || this.myBpelEntityId == null) {
            return;
        }
        if (this.myDiagramAnnotation != null && this.myDiagramAnnotation.getBpelEntityId().equals(this.myBpelEntityId)) {
            this.removeDiagramAnnotation();
        }
        DiagramAnnotation diagramAnnotation = new DiagramAnnotation(this.myBpelEntityId, this.myAnnotationType.getType());
        AnnotationManagerCookie annotationManagerCookie = (AnnotationManagerCookie)this.myDataObject.getCookie(AnnotationManagerCookie.class);
        annotationManagerCookie.addAnnotation(diagramAnnotation);
        this.myDiagramAnnotation = diagramAnnotation;
        BpelAnnotationsObserver.subscribe(this);
    }

    private void removeDiagramAnnotation() {
        if (!this.myAnnotationType.isForDiagram() || this.myBpelEntityId == null) {
            return;
        }
        if (this.myDiagramAnnotation != null) {
            AnnotationManagerCookie annotationManagerCookie = (AnnotationManagerCookie)this.myDataObject.getCookie(AnnotationManagerCookie.class);
            annotationManagerCookie.removeAnnotation(this.myDiagramAnnotation);
            this.myDiagramAnnotation = null;
            BpelAnnotationsObserver.unsubscribe(this);
        }
    }

    private void updateLineAnnotation() {
        if (!this.myAnnotationType.isForSourceEditor() || this.myLineNumber == -1) {
            return;
        }
        Line line = EditorUtil.getLine(this.myDataObject, this.myLineNumber);
        if (line == null) {
            this.removeLineAnnotation();
            return;
        }
        if (this.myLineAnnotation != null && line.equals(this.myLineAnnotation.getAttachedAnnotatable())) {
            return;
        }
        this.removeLineAnnotation();
        this.myLineAnnotation = new LineAnnotation();
        this.myLineAnnotation.attach((Annotatable)line);
    }

    private void removeLineAnnotation() {
        if (!this.myAnnotationType.isForSourceEditor() || this.myLineNumber == -1) {
            return;
        }
        if (this.myLineAnnotation != null) {
            this.myLineAnnotation.detach();
            this.myLineAnnotation = null;
        }
    }

    private void setState(State state) {
        State state2 = this.myState;
        this.myState = state;
        this.firePropertyChange(PROP_STATE, (Object)state2, (Object)state);
    }

    private class LineAnnotation
    extends Annotation {
        private LineAnnotation() {
        }

        public String getAnnotationType() {
            return BpelAnnotation.this.myAnnotationType.getType();
        }

        public String getShortDescription() {
            return BpelAnnotation.this.myAnnotationType.getDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ATTACHED,
        DETACHED;

    }
}

