/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.elements;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DiffElement
extends SimpleRefactoringElementImplementation {
    private final PositionBounds bounds;
    private final String displayText;
    private final FileObject parentFile;
    private final ModificationResult.Difference diff;
    private final ModificationResult modification;
    private WeakReference<String> newFileContent;

    private DiffElement(ModificationResult.Difference difference, PositionBounds positionBounds, FileObject fileObject, ModificationResult modificationResult) {
        this.bounds = positionBounds;
        this.displayText = difference.getDescription();
        this.parentFile = fileObject;
        this.diff = difference;
        this.modification = modificationResult;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        Object object = null;
        if (this.bounds != null) {
            object = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        }
        if (object == null) {
            object = this.parentFile;
        }
        return Lookups.fixed((Object[])new Object[]{object, this.diff});
    }

    public void setEnabled(boolean bl) {
        this.diff.exclude(!bl);
        this.newFileContent = null;
        super.setEnabled(bl);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        if (this.diff.getKind() == ModificationResult.Difference.Kind.CREATE) {
            return this.parentFile.getParent();
        }
        return this.parentFile;
    }

    protected String getNewFileContent() {
        String string;
        if (this.newFileContent != null && (string = (String)this.newFileContent.get()) != null) {
            return string;
        }
        try {
            string = this.diff.getKind() == ModificationResult.Difference.Kind.CREATE ? this.diff.getNewText() : this.modification.getResultingSource(this.parentFile);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        this.newFileContent = new WeakReference<String>(string);
        return string;
    }

    public static DiffElement create(ModificationResult.Difference difference, FileObject fileObject, ModificationResult modificationResult) {
        PositionRef positionRef = difference.getStartPosition();
        PositionRef positionRef2 = difference.getEndPosition();
        PositionBounds positionBounds = null;
        if (difference.getKind() != ModificationResult.Difference.Kind.CREATE) {
            positionBounds = new PositionBounds(positionRef, positionRef2);
        }
        return new DiffElement(difference, positionBounds, fileObject, modificationResult);
    }
}

