/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui.tree;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.netbeans.modules.cnd.refactoring.ui.tree.ElementGripTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.FileTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.ParentTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.ProjectTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.RefactoringTreeElement;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactoryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class TreeElementFactoryImpl
implements TreeElementFactoryImplementation {
    public Map<Object, TreeElement> map = new WeakHashMap<Object, TreeElement>();
    public static TreeElementFactoryImpl instance;

    public TreeElementFactoryImpl() {
        instance = this;
    }

    public TreeElement getTreeElement(Object object) {
        TreeElement treeElement = this.map.get(object);
        if (treeElement != null) {
            return treeElement;
        }
        if (object instanceof RefactoringElement) {
            Lookup lookup = ((RefactoringElement)object).getLookup();
            CsmOffsetable csmOffsetable = (CsmOffsetable)lookup.lookup(CsmOffsetable.class);
            if (csmOffsetable != null) {
                treeElement = new RefactoringTreeElement((RefactoringElement)object);
            } else {
                CsmObject csmObject = (CsmObject)((RefactoringElement)object).getLookup().lookup(CsmObject.class);
                if (csmObject != null) {
                    System.err.println("unhandled CsmObject: " + csmObject);
                }
            }
        } else if (object instanceof ElementGrip) {
            treeElement = new ElementGripTreeElement((ElementGrip)object);
        } else if (CsmKindUtilities.isProject((Object)object)) {
            treeElement = new ProjectTreeElement((CsmProject)object);
        } else if (CsmKindUtilities.isCsmObject((Object)object)) {
            CsmObject csmObject = (CsmObject)object;
            if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
                FileObject fileObject = CsmUtilities.getFileObject((CsmFile)((CsmFile)object));
                treeElement = new FileTreeElement(fileObject, (CsmFile)object);
            } else {
                treeElement = new ParentTreeElement(csmObject);
            }
        } else if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            CsmFile csmFile = CsmUtilities.getCsmFile((FileObject)fileObject, (boolean)false);
            treeElement = new FileTreeElement(fileObject, csmFile);
        }
        if (treeElement != null) {
            this.map.put(object, treeElement);
        }
        return treeElement;
    }

    public void cleanUp() {
        this.map.clear();
        ElementGripFactory.getDefault().cleanUp();
    }
}

