/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;
import sun.misc.BASE64Encoder;

public class Command {
    private static final String DATA_SEPARATOR = " -- ";
    private static final String TRANSACTION_OPT = " -i ";
    public static final String SPACE = " ";
    public static final String FILE_ARG = "-f ";
    public static final String DEPTH_ARG = "-d ";
    private String command;
    private int transactionId;

    Command(String string, int n) {
        this.command = string;
        this.transactionId = n;
    }

    void send(OutputStream outputStream) throws IOException {
        Object object;
        String string = null;
        if (this.getData() != null) {
            object = new BASE64Encoder();
            string = object.encode(this.getData().getBytes("ISO-8859-1"));
        }
        object = new StringBuilder(this.command);
        ((StringBuilder)object).append(this.getArgumentString());
        if (string != null) {
            ((StringBuilder)object).append(DATA_SEPARATOR);
            ((StringBuilder)object).append(string);
        }
        byte[] byArray = ((StringBuilder)object).toString().getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        Log.getLogger().fine("\nCommand: " + new String(byArray2));
        outputStream.write(byArray2);
        outputStream.flush();
    }

    int getTransactionId() {
        return this.transactionId;
    }

    boolean wantAcknowledgment() {
        return true;
    }

    protected String getData() {
        return null;
    }

    protected String getArguments() {
        return "";
    }

    private String getArgumentString() {
        if (this.getArguments() != null && this.getArguments().length() > 0) {
            return TRANSACTION_OPT + this.transactionId + SPACE + this.getArguments();
        }
        return TRANSACTION_OPT + this.transactionId;
    }

    public String toString() {
        return this.getArgumentString();
    }

    public String getCommandName() {
        return this.command;
    }
}

