/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Input;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.w3c.dom.Node;

public class Stack
extends Input {
    private static final String INPUT = "input";
    private static final String CMDEND = "cmdend";
    private static final String CMDBEGIN = "cmdbegin";
    private static final String WHERE = "where";

    Stack(Node node) {
        super(node);
    }

    public String getWhere() {
        return this.getAttribute(WHERE);
    }

    public Position getBeginOffset() {
        return this.getPosition(CMDBEGIN);
    }

    public Position getEndOffset() {
        return this.getPosition(CMDEND);
    }

    public Input getInput() {
        Node node = this.getChild(INPUT);
        if (node == null) {
            return null;
        }
        return new Input(node);
    }

    private Position getPosition(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(":");
        assert (stringArray.length == 2);
        return new Position(stringArray[0], stringArray[1]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StackGetResponse
    extends ResponseMessage {
        private static final String STACK = "stack";

        StackGetResponse(Node node) {
            super(node);
        }

        public List<Stack> getStackElements() {
            LinkedList<Stack> linkedList = new LinkedList<Stack>();
            List<Node> list = StackGetResponse.getChildren(this.getNode(), STACK);
            for (Node node : list) {
                linkedList.add(new Stack(node));
            }
            return linkedList;
        }
    }

    public static class StackGetCommand
    extends Command {
        private int depth;

        public StackGetCommand(int n, int n2) {
            super(CommandMap.STACK_GET.getCommand(), n);
            this.depth = n2;
        }

        public void setDepth(int n) {
            this.depth = n;
        }

        protected String getArguments() {
            if (this.depth > -1) {
                return "-d " + this.depth;
            }
            return super.getArguments();
        }
    }

    public static class StackDepthResponse
    extends ResponseMessage {
        private static final String DEPTH = "depth";

        StackDepthResponse(Node node) {
            super(node);
        }

        public int getDepth() {
            return StackDepthResponse.getInt(this.getNode(), DEPTH);
        }
    }

    public static class StackDepthCommand
    extends Command {
        public StackDepthCommand(int n) {
            super(CommandMap.STACK_DEPTH.getCommand(), n);
        }
    }

    public static class Position {
        private int line;
        private int offset;

        private Position(String string, String string2) {
            try {
                this.line = Integer.parseInt(string);
                this.offset = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.line = -1;
                this.offset = -1;
            }
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        EVAL,
        NATIVE,
        QUEST;


        public String toString() {
            return this != QUEST ? super.toString().toLowerCase() : "?";
        }
    }
}

