/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.openide.util.Utilities;

public class Launcher {
    public static Process launch(LaunchDescriptor launchDescriptor) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(Arrays.asList(launchDescriptor.getLaunchCommand()));
        for (String object2 : launchDescriptor.getURIs()) {
            linkedList.add(object2);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(linkedList);
        Process process = processBuilder.start();
        ProcessWaiter processWaiter = new ProcessWaiter(((Object)linkedList).toString(), process);
        processWaiter.start();
        return process;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LaunchDescriptor {
        private static final String[] MACOS_FIREFOX_LAUNCH_COMMAND = new String[]{"/usr/bin/open", "-b", "org.mozilla.firefox"};
        private String executablePath;
        private String[] computedExecutablePath;
        private List<String> uriList;

        public LaunchDescriptor(String string) {
            this.executablePath = string;
            this.computedExecutablePath = Utilities.isMac() ? MACOS_FIREFOX_LAUNCH_COMMAND : new String[]{string};
        }

        public String[] getLaunchCommand() {
            return this.computedExecutablePath;
        }

        public String getURI() {
            if (this.uriList != null && this.uriList.size() > 0) {
                return this.uriList.get(0);
            }
            return null;
        }

        public void setURI(String string) {
            this.uriList = new ArrayList<String>();
            this.uriList.add(string);
        }

        public void setURI(List<String> list) {
            this.uriList = list;
        }

        public List<String> getURIs() {
            return this.uriList;
        }
    }

    private static class ProcessWaiter
    extends Thread {
        private Process process;
        private String command;

        ProcessWaiter(String string, Process process) {
            this.command = string;
            this.process = process;
            this.setDaemon(true);
        }

        public void run() {
            try {
                int n = this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

