/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.Log;

public class JSURILocation
implements JSLocation {
    private URI uri;
    private int lineNumber;
    private int columnNumber;

    public JSURILocation(URI uRI, int n) {
        this(uRI, n, -1);
    }

    public JSURILocation(URI uRI, int n, int n2) {
        this.uri = uRI;
        this.lineNumber = n;
        this.columnNumber = n2;
    }

    public JSURILocation(URL uRL, int n) {
        this(URI.create(uRL.getPath()), n);
    }

    public JSURILocation(String string, int n, int n2) {
        try {
            this.uri = new URI(string);
            assert (this.uri.isAbsolute());
            this.lineNumber = n;
            this.columnNumber = n2;
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "URI syntax exception", uRISyntaxException);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public JSLocation getJSLocation() {
        return this;
    }

    public String getDisplayName() {
        return this.getURI().toString() + ":" + this.getLineNumber();
    }
}

