/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.spi;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.web.client.tools.common.dbgp.DbgpUtils;
import org.netbeans.modules.web.client.tools.common.dbgp.DebuggerProxy;
import org.netbeans.modules.web.client.tools.common.dbgp.DebuggerServer;
import org.netbeans.modules.web.client.tools.common.dbgp.Feature;
import org.netbeans.modules.web.client.tools.common.dbgp.HttpMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.SourcesMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Status;
import org.netbeans.modules.web.client.tools.common.dbgp.StreamMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.UnsufficientValueException;
import org.netbeans.modules.web.client.tools.common.dbgp.WindowsMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSBreakpoint;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerConsoleEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.modules.web.client.tools.javascript.debugger.spi.JSAbstractDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.spi.Log;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSAbstractExternalDebugger
extends JSAbstractDebugger {
    protected String ID;
    protected DebuggerProxy proxy;
    protected SuspensionPointHandler suspensionPointHandler;
    protected HttpMessageHandler httpMessageHandler;

    public JSAbstractExternalDebugger(URI uRI, HtmlBrowser.Factory factory) {
        super(uRI, factory);
    }

    @Override
    protected void startDebuggingImpl() {
        DebuggerServer debuggerServer = new DebuggerServer(this.getID());
        int n = -1;
        try {
            n = debuggerServer.createSocket();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Unable to create server socket", iOException);
            return;
        }
        this.launchImpl(n);
        try {
            this.proxy = debuggerServer.getDebuggerProxy();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Unable to get the debugger proxy", iOException);
            return;
        }
        this.proxy.startDebugging();
        this.suspensionPointHandler = new SuspensionPointHandler(this.proxy, this.getID());
        this.httpMessageHandler = new HttpMessageHandler(this.proxy, this.getID());
        this.suspensionPointHandler.start();
        this.httpMessageHandler.start();
    }

    protected abstract void launchImpl(int var1);

    @Override
    public void setBooleanFeature(Feature.Name name, boolean bl) {
        this.proxy.setBooleanFeature(name, bl);
    }

    public void openURI(URI uRI) throws URISyntaxException {
        this.setBooleanFeature(Feature.Name.ENABLE, true);
        this.proxy.openURI(uRI);
        this.fireJSDebuggerEvent(new JSDebuggerEvent(this, JSDebuggerState.STARTING_READY));
    }

    @Override
    public void resume() {
        this.proxy.run();
    }

    @Override
    public void pause() {
        this.proxy.pause();
    }

    @Override
    public void stepInto() {
        this.proxy.stepInto();
    }

    @Override
    public void stepOver() {
        this.proxy.stepOver();
    }

    @Override
    public void stepOut() {
        this.proxy.stepOut();
    }

    private void fireDebuggerEvent(Status.StatusResponse statusResponse) {
        if (DbgpUtils.isStepSuccessfull(statusResponse)) {
            JSBreakpoint jSBreakpoint = DbgpUtils.getBreakpoint(statusResponse);
            JSDebuggerState.Reason reason = JSDebuggerState.Reason.STEP;
            if (jSBreakpoint.getId() != null) {
                reason = JSDebuggerState.Reason.BREAKPOINT;
            }
            JSDebuggerState jSDebuggerState = JSDebuggerState.getDebuggerState(jSBreakpoint, reason);
            this.fireJSDebuggerEvent(new JSDebuggerEvent(this, jSDebuggerState));
        }
    }

    @Override
    public boolean isRunningTo(URI uRI, int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void finishImpl(boolean bl) {
        if (this.getDebuggerState() == JSDebuggerState.NOT_CONNECTED) {
            return;
        }
        if (bl) {
            this.setBooleanFeature(Feature.Name.ENABLE, false);
            if (this.proxy != null) {
                this.proxy.stopDebugging();
            }
            if (this.suspensionPointHandler != null) {
                this.suspensionPointHandler.interrupt();
                this.suspensionPointHandler = null;
            }
            this.setDebuggerState(JSDebuggerState.DISCONNECTED_USER);
        }
    }

    @Override
    public void runToCursor(JSURILocation jSURILocation) {
        this.proxy.runToCursor(DbgpUtils.getDbgpBreakpointCommand(this.proxy, jSURILocation, true));
    }

    @Override
    public String setBreakpoint(JSBreakpoint jSBreakpoint) {
        return this.proxy.setBreakpoint(DbgpUtils.getDbgpBreakpointCommand(this.proxy, jSBreakpoint));
    }

    @Override
    public boolean removeBreakpoint(String string) {
        return this.proxy.removeBreakpoint(string);
    }

    @Override
    public boolean updateBreakpoint(String string, Boolean bl, int n, int n2, Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE, String string2) {
        return this.proxy.updateBreakpoint(string, bl, n, n2, hIT_COUNT_FILTERING_STYLE, string2);
    }

    public List<JSBreakpoint> getBreakpoints(List<String> list) {
        return DbgpUtils.getJSBreakpoints(this.proxy.getBreakpoints(list));
    }

    public JSBreakpoint getBreakpoint(String string) {
        return DbgpUtils.getJSBreakpoint(this.proxy.getBreakpoint(string));
    }

    public List<JSBreakpoint> getBreakpoints() {
        return DbgpUtils.getJSBreakpoints(this.proxy.getBreakpoints());
    }

    public JSCallStackFrame getCallStackFrame() {
        return this.getCallStackFrame(-1);
    }

    public JSCallStackFrame getCallStackFrame(int n) {
        return DbgpUtils.getJSCallStackFrame(this, this.proxy.getCallStack(n));
    }

    @Override
    protected JSCallStackFrame[] getCallStackFramesImpl() {
        return DbgpUtils.getJSCallStackFrames(this, this.proxy.getCallStacks()).toArray(JSCallStackFrame.EMPTY_ARRAY);
    }

    @Override
    protected JSProperty getScopeImpl(JSCallStackFrame jSCallStackFrame) {
        return this.getPropertyImpl(jSCallStackFrame, ".");
    }

    @Override
    protected JSProperty getThisImpl(JSCallStackFrame jSCallStackFrame) {
        return this.getPropertyImpl(jSCallStackFrame, "this");
    }

    @Override
    protected JSProperty evalImpl(JSCallStackFrame jSCallStackFrame, String string) {
        return DbgpUtils.getJSProperty(jSCallStackFrame, this.proxy.eval(string, jSCallStackFrame.getDepth()));
    }

    @Override
    protected JSProperty getPropertyImpl(JSCallStackFrame jSCallStackFrame, String string) {
        return DbgpUtils.getJSProperty(jSCallStackFrame, this.proxy.getProperty(string, jSCallStackFrame.getDepth()));
    }

    @Override
    protected boolean setPropertyImpl(JSCallStackFrame jSCallStackFrame, String string, String string2) {
        return this.proxy.setProperty(string, string2, jSCallStackFrame.getDepth());
    }

    @Override
    protected JSProperty[] getPropertiesImpl(JSCallStackFrame jSCallStackFrame, String string) {
        return DbgpUtils.getJSProperties(jSCallStackFrame, this.proxy.getProperty(string, jSCallStackFrame.getDepth()));
    }

    private void handleSourcesMessage(SourcesMessage sourcesMessage) {
        this.setSources(JSFactory.getJSSources(sourcesMessage.getSources()));
    }

    private void handleWindowsMessage(WindowsMessage windowsMessage) {
        this.setWindows(JSFactory.getJSWindows(windowsMessage.getWindows()));
    }

    private void handleStreamMessage(StreamMessage streamMessage) {
        JSDebuggerConsoleEvent jSDebuggerConsoleEvent = null;
        try {
            jSDebuggerConsoleEvent = new JSDebuggerConsoleEvent(this, JSDebuggerConsoleEvent.ConsoleType.valueOf(streamMessage.getType().toUpperCase()), streamMessage.getStringValue());
        }
        catch (UnsufficientValueException unsufficientValueException) {
            Log.getLogger().log(Level.INFO, "Unable to get the console message", unsufficientValueException);
        }
        this.fireJSDebuggerConsoleEvent(jSDebuggerConsoleEvent);
    }

    private void handleHttpMessage(HttpMessage httpMessage) {
        JSHttpMessage jSHttpMessage = JSFactory.createJSHttpMessage(httpMessage);
        this.setHttpMessage(jSHttpMessage);
    }

    protected class SuspensionPointHandler
    extends Thread {
        DebuggerProxy proxy;

        SuspensionPointHandler(DebuggerProxy debuggerProxy, String string) {
            super("Suspension point handler");
            this.setDaemon(true);
            this.proxy = debuggerProxy;
        }

        public void run() {
            Log.getLogger().log(Level.FINEST, "Starting " + this.getName());
            while (this.proxy.isActive()) {
                Message message = this.getNextMessage();
                if (message == null) continue;
                this.handle(message);
            }
            Log.getLogger().log(Level.FINEST, "Ending " + this.getName());
        }

        private Message getNextMessage() {
            return this.proxy.getSuspensionPoint();
        }

        private void handle(Message message) {
            JSDebuggerState jSDebuggerState;
            if (message instanceof SourcesMessage) {
                JSAbstractExternalDebugger.this.handleSourcesMessage((SourcesMessage)message);
                return;
            }
            if (message instanceof WindowsMessage) {
                JSAbstractExternalDebugger.this.handleWindowsMessage((WindowsMessage)message);
                return;
            }
            if (message instanceof StreamMessage) {
                JSAbstractExternalDebugger.this.handleStreamMessage((StreamMessage)message);
            }
            if ((jSDebuggerState = DbgpUtils.getDebuggerState(message)) != null) {
                JSAbstractExternalDebugger.this.setDebuggerState(jSDebuggerState);
                if (jSDebuggerState.getReason().equals((Object)JSDebuggerState.Reason.INIT)) {
                    try {
                        JSAbstractExternalDebugger.this.openURI(JSAbstractExternalDebugger.this.getURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Exceptions.printStackTrace((Throwable)uRISyntaxException);
                    }
                }
            }
        }
    }

    protected class HttpMessageHandler
    extends Thread {
        DebuggerProxy proxy;

        HttpMessageHandler(DebuggerProxy debuggerProxy, String string) {
            super("Http Mesasge Handler");
            this.setDaemon(true);
            this.proxy = debuggerProxy;
        }

        public void run() {
            Log.getLogger().log(Level.FINEST, "Starting " + this.getName());
            while (this.proxy.isActive()) {
                Message message = this.getNextMessage();
                if (message == null) continue;
                this.handle(message);
            }
            Log.getLogger().log(Level.FINEST, "Ending " + this.getName());
        }

        private Message getNextMessage() {
            return this.proxy.getHttpMessage();
        }

        private void handle(Message message) {
            if (message instanceof HttpMessage) {
                JSAbstractExternalDebugger.this.handleHttpMessage((HttpMessage)message);
                return;
            }
            Logger.getLogger(this.getName()).info("Something Seems Wrong");
        }
    }
}

