/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.config.sync;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.websphere6.config.sync.Synchronizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WarSynchronizer
extends Synchronizer {
    private static final Logger LOGGER = Logger.getLogger(WarSynchronizer.class.getName());
    private final File ibmwebbndFile;
    private final File webxmlFile;
    private XPath xpath = null;
    private boolean saveIbmWebBndNeeded = false;
    private boolean saveWebXmlNeeded = false;

    public WarSynchronizer(File file, File file2) {
        this.webxmlFile = file;
        this.ibmwebbndFile = file2;
        try {
            this.xpath = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom").newXPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.xpath = null;
        }
    }

    public synchronized void syncDescriptors() {
        if (this.webxmlFile != null && this.ibmwebbndFile != null) {
            try {
                this.saveIbmWebBndNeeded = false;
                this.saveWebXmlNeeded = false;
                Document document = this.loadDocument(this.webxmlFile);
                Document document2 = this.loadDocument(this.ibmwebbndFile);
                this.syncEjbReferences(document, document2);
                this.syncRootId(document, document2);
                if (this.saveWebXmlNeeded) {
                    this.saveDocument(document, this.webxmlFile);
                }
                if (this.saveIbmWebBndNeeded) {
                    this.saveDocument(document2, this.ibmwebbndFile);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void syncRootId(Document document, Document document2) {
        if (!"WebApp".equals(document.getDocumentElement().getAttribute("id"))) {
            Attr attr = document.createAttribute("id");
            attr.setValue("WebApp");
            document.getDocumentElement().getAttributes().setNamedItem(attr);
            this.saveWebXmlNeeded = true;
        }
    }

    private void syncEjbReferences(Document document, Document document2) {
        try {
            String[] stringArray = new String[]{"ejb-ref", "ejb-local-ref"};
            for (Reference reference : new Reference[]{Reference.LOCAL, Reference.REMOTE}) {
                String string;
                String string2;
                Node node;
                int n;
                NodeList nodeList = (NodeList)this.xpath.compile("./" + reference.getTagName()).evaluate(document.getDocumentElement(), XPathConstants.NODESET);
                Element element = document2.getDocumentElement();
                if (element == null) {
                    return;
                }
                NodeList nodeList2 = (NodeList)this.xpath.compile("./ejbRefBindings").evaluate(element, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    string2 = this.getBeanId(node);
                    if (string2 != null && this.bindingExists(element, string2)) continue;
                    string = this.getInterfaceName(node, reference);
                    String string3 = this.getEjbRefNameName(node);
                    if (string2 == null) {
                        string2 = this.createBeanId(node, string3);
                    }
                    Attr attr = document.createAttribute("id");
                    attr.setValue(string2);
                    node.getAttributes().setNamedItem(attr);
                    Node node2 = this.constructBinding(document2, this.getBeanId(node), this.getBindingJNDIName(string, reference), reference);
                    element.appendChild(document2.createTextNode("    "));
                    element.appendChild(node2);
                    element.appendChild(document2.createTextNode("\n"));
                    this.saveIbmWebBndNeeded = true;
                    this.saveWebXmlNeeded = true;
                }
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    node = nodeList2.item(n);
                    string2 = this.getBindingId(node);
                    string = this.getBindingType(node);
                    if ((!"common:EJBLocalRef".equals(string) || !reference.isLocal()) && (string != null || !reference.isRemote()) || this.ejbReferenceExists(document, string2, reference) && this.isEjbReferenceValid(document, string2, reference)) continue;
                    element.removeChild(node);
                    this.saveIbmWebBndNeeded = true;
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            LOGGER.log(Level.INFO, null, xPathExpressionException);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            LOGGER.log(Level.INFO, null, xPathFactoryConfigurationException);
        }
    }

    private String getReferenceJNDIName(Object[] objectArray, String string, Reference reference) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            File file = (File)objectArray[i];
            File file2 = new File(file, "src" + File.separator + "conf" + File.separator + "ejb-jar.xml");
            File file3 = new File(file, "src" + File.separator + "conf" + File.separator + "ibm-ejb-jar-bnd.xmi");
            String string2 = null;
            try {
                Document document = this.loadDocument(file2);
                Document document2 = this.loadDocument(file3);
                Node node = (Node)this.xpath.compile("./enterprise-beans/session[" + (reference.isLocal() ? "local" : "remote") + "=\"" + string + "\"]").evaluate(document.getDocumentElement(), XPathConstants.NODE);
                Node node2 = node.getAttributes().getNamedItem("id");
                String string3 = node2.getTextContent();
                Node node3 = (Node)this.xpath.compile("./ejbBindings/enterpriseBean[@href=\"META-INF/ejb-jar.xml#" + string3 + "\"]").evaluate(document2.getDocumentElement(), XPathConstants.NODE);
                string2 = node3.getParentNode().getAttributes().getNamedItem("jndiName").getTextContent();
                this.addSyncFile(file2);
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (XPathExpressionException xPathExpressionException) {
                continue;
            }
            return string2;
        }
        return null;
    }

    private String getInterfaceName(Node node, Reference reference) throws XPathExpressionException {
        String string = ((Node)this.xpath.compile(reference.isLocal() ? "child::local" : "child::remote").evaluate(node, XPathConstants.NODE)).getTextContent();
        return string;
    }

    private String getEjbRefNameName(Node node) throws XPathExpressionException {
        String string = ((Node)this.xpath.compile("child::ejb-ref-name").evaluate(node, XPathConstants.NODE)).getTextContent();
        return string;
    }

    private String getBeanId(Node node) {
        Node node2 = node.getAttributes().getNamedItem("id");
        return node2 != null ? node2.getTextContent() : null;
    }

    private Object[] getEjbDirectoryList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)this.webxmlFile));
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        Properties properties = new Properties();
        Document document = this.loadDocument(new File(file, "nbproject" + File.separator + "project.xml"));
        try {
            NodeList nodeList = (NodeList)this.xpath.compile("./configuration/references/reference/foreign-project").evaluate(document.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getTextContent();
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(file, "nbproject" + File.separator + "project.properties"));
                    properties.clear();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    String string2 = properties.getProperty("project." + string);
                    if (string2 == null) continue;
                    arrayList.add(new File(file, string2));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        return arrayList.toArray();
    }

    private String getBindingJNDIName(String string, Reference reference) throws XPathFactoryConfigurationException, XPathExpressionException {
        return this.getReferenceJNDIName(this.getEjbDirectoryList(), string, reference);
    }

    private String createBeanId(Node node, String string) throws XPathFactoryConfigurationException, XPathExpressionException {
        String string2 = string;
        if (string2.lastIndexOf("/") != -1) {
            string2 = string2.substring(string2.lastIndexOf("/") + 1);
        }
        string2 = string2.replaceAll("\\.", "_");
        return string2 + "__Bnd__" + new Date().getTime();
    }

    private boolean ejbReferenceExists(Document document, String string, Reference reference) throws XPathExpressionException, XPathFactoryConfigurationException {
        String string2 = "./" + reference.getTagName() + "[@id=\"" + string + "\"]";
        Node node = (Node)this.xpath.compile(string2).evaluate(document.getDocumentElement(), XPathConstants.NODE);
        return node != null;
    }

    private boolean isEjbReferenceValid(Document document, String string, Reference reference) throws XPathExpressionException, XPathFactoryConfigurationException {
        String string2 = "./" + reference.getTagName() + "[@id=\"" + string + "\"]";
        Node node = (Node)this.xpath.compile(string2).evaluate(document.getDocumentElement(), XPathConstants.NODE);
        String string3 = ((Node)this.xpath.compile(reference.isLocal() ? "child::local" : "child::remote").evaluate(node, XPathConstants.NODE)).getTextContent();
        boolean bl = this.getReferenceJNDIName(this.getEjbDirectoryList(), string3, reference) != null;
        return bl;
    }

    private String getBindingId(Node node) {
        Node node2 = node.getAttributes().getNamedItem("xmi:id");
        if (node2 != null) {
            return node2.getTextContent();
        }
        return null;
    }

    private String getBindingType(Node node) throws XPathExpressionException, XPathFactoryConfigurationException {
        Node node2 = (Node)this.xpath.compile("./bindingEjbRef").evaluate(node, XPathConstants.NODE);
        Node node3 = node2.getAttributes().getNamedItem("xmi:type");
        if (node3 != null) {
            return node3.getTextContent();
        }
        return null;
    }

    private boolean bindingExists(Node node, String string) throws XPathFactoryConfigurationException, XPathExpressionException {
        String string2 = "./ejbRefBindings[@id=\"" + string + "\"]";
        Node node2 = (Node)this.xpath.compile(string2).evaluate(node, XPathConstants.NODE);
        return node2 != null;
    }

    private Node constructBinding(Document document, String string, String string2, Reference reference) {
        Element element = document.createElement("ejbRefBindings");
        element.setAttribute("jndiName", string2 == null ? "ejb/" + string : string2);
        element.setAttributeNS("http://www.omg.org/XMI", "xmi:id", string);
        Element element2 = document.createElement("bindingEjbRef");
        element2.setAttribute("href", "WEB-INF/web.xml#" + string);
        if (reference.isLocal()) {
            element2.setAttribute("xmi:type", "common:EJBLocalRef");
        }
        element.appendChild(document.createTextNode("\n        "));
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
        return element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Reference {
        LOCAL,
        REMOTE;


        public String getTagName() {
            switch (this) {
                case LOCAL: {
                    return "ejb-local-ref";
                }
                case REMOTE: {
                    return "ejb-ref";
                }
            }
            return null;
        }

        public boolean isLocal() {
            switch (this) {
                case LOCAL: {
                    return true;
                }
                case REMOTE: {
                    return false;
                }
            }
            return false;
        }

        public boolean isRemote() {
            switch (this) {
                case LOCAL: {
                    return false;
                }
                case REMOTE: {
                    return true;
                }
            }
            return false;
        }
    }
}

