/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DDUtils {
    private static final String EXCEPTION_PREFIX = "version";

    public static SAXParseException parse(InputSource inputSource) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            SAXParser sAXParser = DDUtils.createSAXParserFactory().newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.parse(inputSource);
            SAXParseException sAXParseException = errorHandler.getError();
            if (sAXParseException != null) {
                return sAXParseException;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        return null;
    }

    private static SAXParserFactory createSAXParserFactory() throws ParserConfigurationException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            if (sAXParserFactory != null) {
                try {
                    sAXParserFactory.getClass().getMethod("getSchema", new Class[0]);
                    return sAXParserFactory;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
        }
        catch (Exception exception) {
            throw new ParserConfigurationException(exception.getMessage());
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String string, String string2) {
            String string3 = null;
            if ("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(string)) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_3.dtd";
            } else if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(string)) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_2.dtd";
            } else if (string2 != null && string2.endsWith("web-app_2_4.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_4.xsd";
            }
            if (string3 == null) {
                return null;
            }
            URL uRL = this.getClass().getResource(string3);
            return new InputSource(uRL.toString());
        }
    }
}

