/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.appbnd;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.websphere6.dd.beans.AuthorizationsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSAppBnd;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.appbnd.PanelFactory;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.appbnd.WSAppBndDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WSAppBndToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private ToolBarDesignEditor comp;
    private SectionView view;
    private WSAppBndDataObject dObj;
    private PanelFactory factory;
    private RequestProcessor.Task repaintingTask;
    private boolean needInit = true;
    private static final long serialVersionUID = 76117428339792L;
    private Action addAuthorizationAction;
    private Action removeAuthorizationAction;
    private static final String APPBND_MV_ID = "appbnd_multiview_design";

    public WSAppBndToolBarMVElement(WSAppBndDataObject wSAppBndDataObject) {
        super((XmlMultiViewDataObject)wSAppBndDataObject);
        this.dObj = wSAppBndDataObject;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PanelFactory(this.comp, wSAppBndDataObject);
        this.addAuthorizationAction = new AddAuthorizationAction(NbBundle.getMessage(WSAppBndToolBarMVElement.class, (String)"LBL_addAuthorization"));
        this.removeAuthorizationAction = new RemoveAuthorizationAction(NbBundle.getMessage(WSAppBndToolBarMVElement.class, (String)"LBL_removeAuthorization"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WSAppBndToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    private void repaintView() {
        this.view = new WSAppBndView(this.dObj);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        }
        this.view.checkValidity();
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public WSAppBndView getAppBndView() {
        return (WSAppBndView)this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            this.repaintView();
            this.needInit = false;
        }
        this.comp.setContentView((PanelView)this.view);
        try {
            this.view.openPanel((Object)this.dObj.getAppBnd());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.view.checkValidity();
    }

    public void componentOpened() {
        super.componentOpened();
        try {
            this.dObj.getAppBnd().addPropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void componentClosed() {
        super.componentClosed();
        try {
            this.dObj.getAppBnd().removePropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("ApplicationBnd") > 0) {
            if (APPBND_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    public Error validateView() {
        return null;
    }

    public static class AuthorizationNode
    extends AbstractNode {
        public AuthorizationNode() {
            super(Children.LEAF);
            this.setDisplayName("Authorization #");
        }
    }

    public static class WSAppBndNode
    extends AbstractNode {
        WSAppBndNode(WSAppBndDataObject wSAppBndDataObject) {
            super(Children.LEAF);
            this.setDisplayName("Binding Deployment Information");
        }
    }

    private class RemoveAuthorizationAction
    extends AbstractAction {
        RemoveAuthorizationAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            AuthorizationsType authorizationsType = (AuthorizationsType)sectionPanel.getKey();
            try {
                WSAppBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSAppBndToolBarMVElement.this.dObj.getAppBnd().getAuthorizationTable().removeAuthorization(authorizationsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                sectionPanel.getSectionView().updateUI();
                sectionPanel.updateUI();
                WSAppBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
            }
            catch (IOException iOException) {
            }
            finally {
                WSAppBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddAuthorizationAction
    extends AbstractAction {
        AddAuthorizationAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSAppBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                long l = System.currentTimeMillis();
                WSAppBnd wSAppBnd = WSAppBndToolBarMVElement.this.dObj.getAppBnd();
                int n = wSAppBnd.getAuthorizationTable().sizeAuthorizations() + 1;
                AuthorizationsType authorizationsType = new AuthorizationsType();
                authorizationsType.setDefaults();
                wSAppBnd.getAuthorizationTable().addAuthorization(authorizationsType);
                AuthorizationNode authorizationNode = new AuthorizationNode();
                WSAppBndToolBarMVElement.this.view.getRoot().getChildren().add(new Node[]{authorizationNode});
                authorizationNode.setDisplayName(authorizationNode.getDisplayName() + n);
                WSAppBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSAppBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSAppBndToolBarMVElement.this.view, (Node)authorizationNode, (Object)authorizationsType);
                sectionPanel.setHeaderActions(new Action[]{WSAppBndToolBarMVElement.this.removeAuthorizationAction});
                ((WSAppBndView)WSAppBndToolBarMVElement.this.view).getAuthorizationsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSAppBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class WSAppBndView
    extends SectionView {
        private SectionContainer bindingsCont;
        private WSAppBnd appbnd;
        private SectionContainer authorizationsCont;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WSAppBndView(WSAppBndDataObject wSAppBndDataObject) {
            super((InnerPanelFactory)WSAppBndToolBarMVElement.this.factory);
            Children.Array array = new Children.Array();
            AbstractNode abstractNode = new AbstractNode((Children)array);
            try {
                this.appbnd = wSAppBndDataObject.getAppBnd();
                array.add(new Node[]{this.createAppBndAttrNode(), this.createAppAuthorizationsNode()});
            }
            catch (IOException iOException) {
                System.out.println("ex=" + iOException);
                abstractNode.setDisplayName("Invalid AppBnd");
            }
            finally {
                this.setRoot((Node)abstractNode);
            }
        }

        public SectionContainer getAuthorizationsContainer() {
            return this.authorizationsCont;
        }

        private Node createAppBndAttrNode() {
            WSAppBndNode wSAppBndNode = new WSAppBndNode(WSAppBndToolBarMVElement.this.dObj);
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)wSAppBndNode, (Object)this.appbnd));
            return wSAppBndNode;
        }

        private Node createAppAuthorizationsNode() {
            AuthorizationsType[] authorizationsTypeArray = this.appbnd.getAuthorizationTable().getAuthorizations();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (authorizationsTypeArray != null && authorizationsTypeArray.length > 0) {
                nodeArray = new Node[authorizationsTypeArray.length];
                for (int i = 0; i < authorizationsTypeArray.length; ++i) {
                    nodeArray[i] = new AuthorizationNode();
                    nodeArray[i].setDisplayName("Authorization #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Authorizations");
            this.authorizationsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Authorizations");
            this.authorizationsCont.setHeaderActions(new Action[]{WSAppBndToolBarMVElement.this.addAuthorizationAction});
            if (authorizationsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[authorizationsTypeArray.length];
                for (int i = 0; i < authorizationsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)authorizationsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSAppBndToolBarMVElement.this.removeAuthorizationAction});
                    this.authorizationsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.authorizationsCont);
            return sectionContainerNode;
        }
    }
}

