/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.ejbbnd;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.websphere6.dd.beans.EjbBindingsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSEjbBnd;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ejbbnd.PanelFactory;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ejbbnd.WSEjbBndDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WSEjbBndToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private ToolBarDesignEditor comp;
    private SectionView view;
    private WSEjbBndDataObject dObj;
    private PanelFactory factory;
    private RequestProcessor.Task repaintingTask;
    private boolean needInit = true;
    private Action addBindingAction;
    private Action removeBindingAction;
    private static final long serialVersionUID = 76737428339792L;
    private static final String EJBBND_MV_ID = "ejbbnd_multiview_design";

    public WSEjbBndToolBarMVElement(WSEjbBndDataObject wSEjbBndDataObject) {
        super((XmlMultiViewDataObject)wSEjbBndDataObject);
        this.dObj = wSEjbBndDataObject;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PanelFactory(this.comp, wSEjbBndDataObject);
        this.addBindingAction = new AddBindingAction(NbBundle.getMessage(WSEjbBndToolBarMVElement.class, (String)"LBL_addEjbBinding"));
        this.removeBindingAction = new RemoveBindingAction(NbBundle.getMessage(WSEjbBndToolBarMVElement.class, (String)"LBL_removeEjbBinding"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WSEjbBndToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    private void repaintView() {
        this.view = new WSEjbBndView(this.dObj);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        }
        this.view.checkValidity();
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public WSEjbBndView getEjbBndView() {
        return (WSEjbBndView)this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            this.repaintView();
            this.needInit = false;
        }
        this.comp.setContentView((PanelView)this.view);
        try {
            this.view.openPanel((Object)this.dObj.getEjbBnd());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.view.checkValidity();
    }

    public void componentOpened() {
        super.componentOpened();
        try {
            this.dObj.getEjbBnd().addPropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void componentClosed() {
        super.componentClosed();
        try {
            this.dObj.getEjbBnd().removePropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("EjbJarBnd") > 0) {
            if (EJBBND_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    public Error validateView() {
        return null;
    }

    public static class BindingNode
    extends AbstractNode {
        public BindingNode() {
            super(Children.LEAF);
            this.setDisplayName("Ejb Binding #");
        }
    }

    public static class WSEjbBndNode
    extends AbstractNode {
        WSEjbBndNode(WSEjbBndDataObject wSEjbBndDataObject) {
            super(Children.LEAF);
            this.setDisplayName("Binding Deployment Information");
        }
    }

    private class RemoveBindingAction
    extends AbstractAction {
        RemoveBindingAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            EjbBindingsType ejbBindingsType = (EjbBindingsType)sectionPanel.getKey();
            try {
                WSEjbBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSEjbBndToolBarMVElement.this.dObj.getEjbBnd().removeEjbBindings(ejbBindingsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                sectionPanel.getSectionView().updateUI();
                sectionPanel.updateUI();
                WSEjbBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
            }
            catch (IOException iOException) {
            }
            finally {
                WSEjbBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddBindingAction
    extends AbstractAction {
        AddBindingAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSEjbBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                long l = System.currentTimeMillis();
                WSEjbBnd wSEjbBnd = WSEjbBndToolBarMVElement.this.dObj.getEjbBnd();
                int n = wSEjbBnd.sizeEjbBindings() + 1;
                EjbBindingsType ejbBindingsType = new EjbBindingsType();
                ejbBindingsType.setEnterpriseBean("");
                ejbBindingsType.setJndiName("Binding_" + l);
                ejbBindingsType.setXmiId("Binding_" + l);
                ejbBindingsType.setHref("EnterpriseBean_" + l);
                wSEjbBnd.addEjbBindings(ejbBindingsType);
                BindingNode bindingNode = new BindingNode();
                WSEjbBndToolBarMVElement.this.view.getRoot().getChildren().add(new Node[]{bindingNode});
                bindingNode.setDisplayName(bindingNode.getDisplayName() + n);
                WSEjbBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSEjbBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSEjbBndToolBarMVElement.this.view, (Node)bindingNode, (Object)ejbBindingsType);
                sectionPanel.setHeaderActions(new Action[]{WSEjbBndToolBarMVElement.this.removeBindingAction});
                ((WSEjbBndView)WSEjbBndToolBarMVElement.this.view).getEjbBindingsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSEjbBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class WSEjbBndView
    extends SectionView {
        private SectionContainer bindingsCont;
        private WSEjbBnd ejbbnd;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WSEjbBndView(WSEjbBndDataObject wSEjbBndDataObject) {
            super((InnerPanelFactory)WSEjbBndToolBarMVElement.this.factory);
            Children.Array array = new Children.Array();
            AbstractNode abstractNode = new AbstractNode((Children)array);
            try {
                this.ejbbnd = wSEjbBndDataObject.getEjbBnd();
                array.add(new Node[]{this.createEjbBndAttrNode(), this.createEjbBindingsNode()});
            }
            catch (IOException iOException) {
                System.out.println("ex=" + iOException);
                abstractNode.setDisplayName("Invalid EjbBnd");
            }
            finally {
                this.setRoot((Node)abstractNode);
            }
        }

        public SectionContainer getEjbBindingsContainer() {
            return this.bindingsCont;
        }

        private Node createEjbBndAttrNode() {
            WSEjbBndNode wSEjbBndNode = new WSEjbBndNode(WSEjbBndToolBarMVElement.this.dObj);
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)wSEjbBndNode, (Object)this.ejbbnd));
            return wSEjbBndNode;
        }

        private Node createEjbBindingsNode() {
            EjbBindingsType[] ejbBindingsTypeArray = this.ejbbnd.getEjbBindings();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (ejbBindingsTypeArray != null && ejbBindingsTypeArray.length > 0) {
                nodeArray = new Node[ejbBindingsTypeArray.length];
                for (int i = 0; i < ejbBindingsTypeArray.length; ++i) {
                    nodeArray[i] = new BindingNode();
                    nodeArray[i].setDisplayName("Ejb Binding #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Ejb Bindings");
            this.bindingsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Ejb Bindings");
            this.bindingsCont.setHeaderActions(new Action[]{WSEjbBndToolBarMVElement.this.addBindingAction});
            if (ejbBindingsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[ejbBindingsTypeArray.length];
                for (int i = 0; i < ejbBindingsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)ejbBindingsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSEjbBndToolBarMVElement.this.removeBindingAction});
                    this.bindingsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.bindingsCont);
            return sectionContainerNode;
        }
    }
}

