/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSEjbBnd;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.WSMultiViewDataObject;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ui.CMPConnectionFactory;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.openide.util.NbBundle;

public class WSEjbBndAttributesPanel
extends SectionInnerPanel
implements ItemListener {
    WSEjbBnd ejbbnd;
    WSMultiViewDataObject dObj;
    private JTextField cmpConnectionFactoryNameField;
    private JTextField cmpConnectionFactoryJndiNameField;
    private JCheckBox cmpConnectionFactoryCheckBox;
    private JComboBox cmpConnectionFactoryAuthType;
    private static final String FACTORY_NAME = "Default CMP Connection Factory Name";
    private static final String FACTORY_JNDI_NAME = "Default CMP Connection Factory JNDI Name";
    private JPanel cmpConnectionFactoryPanel;
    private JTextField currentBackendIdField;
    private JLabel currentBackendIdLabel;
    private JTextField hrefField;
    private JTextField nameField;
    private JLabel nameLabel;
    private JLabel rootId;

    public WSEjbBndAttributesPanel(SectionView sectionView, WSMultiViewDataObject wSMultiViewDataObject, WSEjbBnd wSEjbBnd) {
        super(sectionView);
        this.dObj = wSMultiViewDataObject;
        this.ejbbnd = wSEjbBnd;
        this.initComponents();
        this.bindCmpConnectionFactoryComponents();
        this.initCmpConnectionFactoryComponents();
        this.nameField.setText(wSEjbBnd.getXmiId());
        this.hrefField.setText(wSEjbBnd.getEjbJarHref());
        this.currentBackendIdField.setText(wSEjbBnd.getCurrentBackendId());
        this.addModifier(this.nameField);
        this.addModifier(this.hrefField);
        this.addModifier(this.currentBackendIdField);
    }

    private void bindCmpConnectionFactoryComponents() {
        CMPConnectionFactory cMPConnectionFactory = (CMPConnectionFactory)this.cmpConnectionFactoryPanel;
        this.cmpConnectionFactoryNameField = cMPConnectionFactory.getNameField();
        this.cmpConnectionFactoryJndiNameField = cMPConnectionFactory.getJndiNameField();
        this.cmpConnectionFactoryCheckBox = cMPConnectionFactory.getFactoryCheckBox();
        this.cmpConnectionFactoryAuthType = cMPConnectionFactory.getAuthTypeComboBox();
        cMPConnectionFactory.setComponentsBackground(SectionVisualTheme.getSectionActiveBackgroundColor());
        cMPConnectionFactory.setEnabledComponents();
    }

    private void initCmpConnectionFactoryComponents() {
        this.addModifier(this.cmpConnectionFactoryNameField);
        this.addModifier(this.cmpConnectionFactoryJndiNameField);
        this.addValidatee(this.cmpConnectionFactoryNameField);
        this.addValidatee(this.cmpConnectionFactoryJndiNameField);
        boolean bl = this.ejbbnd.getCmpConnectionFactory() != null;
        this.cmpConnectionFactoryCheckBox.setSelected(bl);
        if (bl) {
            this.cmpConnectionFactoryNameField.setText(this.ejbbnd.getCmpConnectionFactoryXmiId());
            this.cmpConnectionFactoryJndiNameField.setText(this.ejbbnd.getCmpConnectionFactoryJndiName());
            this.cmpConnectionFactoryAuthType.setSelectedItem(this.ejbbnd.getCmpConnectionFactoryResAuth());
        }
        this.cmpConnectionFactoryCheckBox.addItemListener(this);
        this.cmpConnectionFactoryAuthType.addItemListener(this);
        ((CMPConnectionFactory)this.cmpConnectionFactoryPanel).setEnabledComponents();
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.nameField) {
            this.ejbbnd.setXmiId((String)object);
        } else if (jComponent == this.hrefField) {
            this.ejbbnd.setEjbJarHref((String)object);
        } else if (jComponent == this.currentBackendIdField) {
            this.ejbbnd.setCurrentBackendId((String)object);
        } else if (jComponent == this.cmpConnectionFactoryNameField) {
            this.ejbbnd.setCmpConnectionFactoryXmiId((String)object);
        } else if (jComponent == this.cmpConnectionFactoryJndiNameField) {
            this.ejbbnd.setCmpConnectionFactoryJndiName((String)object);
        }
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (this.nameField == jTextComponent) {
            this.nameField.setText(this.ejbbnd.getXmiId());
        }
        if (this.hrefField == jTextComponent) {
            this.hrefField.setText(this.ejbbnd.getEjbJarHref());
        }
        if (this.currentBackendIdField == jTextComponent) {
            this.currentBackendIdField.setText(this.ejbbnd.getCurrentBackendId());
        }
        if (this.cmpConnectionFactoryNameField == jTextComponent) {
            this.cmpConnectionFactoryNameField.setText(this.ejbbnd.getCmpConnectionFactoryXmiId());
        }
        if (this.cmpConnectionFactoryJndiNameField == jTextComponent) {
            this.cmpConnectionFactoryNameField.setText(this.ejbbnd.getCmpConnectionFactoryJndiName());
        }
    }

    public JComponent getErrorComponent(String string) {
        if ("Name".equals(string)) {
            return this.nameField;
        }
        if ("Ejb-Jar ID".equals(string)) {
            return this.hrefField;
        }
        if ("Current Backend ID".equals(string)) {
            return this.currentBackendIdField;
        }
        return null;
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        String string2;
        if (jTextComponent == this.nameField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Name", (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.hrefField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Ejb-Jar ID", (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.currentBackendIdField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Current Backend ID", (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.cmpConnectionFactoryNameField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, FACTORY_NAME, (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.cmpConnectionFactoryJndiNameField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, FACTORY_JNDI_NAME, (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    private void changeCmpConnectionFactoryState() {
        if (this.cmpConnectionFactoryCheckBox.isSelected()) {
            this.ejbbnd.setCmpConnectionFactory("");
            this.ejbbnd.setCmpConnectionFactoryXmiId(this.cmpConnectionFactoryNameField.getText());
            this.ejbbnd.setCmpConnectionFactoryResAuth(this.cmpConnectionFactoryAuthType.getSelectedItem().toString());
        } else {
            this.ejbbnd.setCmpConnectionFactory(null);
        }
        ((CMPConnectionFactory)this.cmpConnectionFactoryPanel).setEnabledComponents();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dObj.setChangedFromUI(true);
        this.changeCmpConnectionFactoryState();
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.currentBackendIdLabel = new JLabel();
        this.currentBackendIdField = new JTextField();
        this.rootId = new JLabel();
        this.hrefField = new JTextField();
        this.cmpConnectionFactoryPanel = new CMPConnectionFactory();
        ((CMPConnectionFactory)this.cmpConnectionFactoryPanel).getFactoryCheckBox().setText(NbBundle.getMessage(CMPConnectionFactory.class, (String)"LBL_DefaultCMPConnectionFactory"));
        this.nameLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_Name"));
        this.currentBackendIdLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_CurrentBackendId"));
        this.rootId.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_EjbJarId"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(58, 58, 58).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.rootId).add((Component)this.nameLabel, -2, 35, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.hrefField, -1, 345, Short.MAX_VALUE).add((Component)this.nameField, -1, 345, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.currentBackendIdLabel).addPreferredGap(0).add((Component)this.currentBackendIdField, -1, 347, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.cmpConnectionFactoryPanel, -1, 449, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameField, -2, -1, -2).add((Component)this.nameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rootId, -1, 14, Short.MAX_VALUE).add((Component)this.hrefField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.currentBackendIdLabel).add((Component)this.currentBackendIdField, -2, -1, -2)).addPreferredGap(0).add((Component)this.cmpConnectionFactoryPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

