/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.j2ee.websphere6.ui.Instance;
import org.netbeans.modules.j2ee.websphere6.ui.InstancesModel;
import org.netbeans.modules.j2ee.websphere6.ui.wizard.WSInstantiatingIterator;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServerProperties {
    private static final Logger LOGGER = Logger.getLogger(ServerProperties.class.getName());
    private JComboBox serverTypeCombo;
    private JComboBox localInstancesCombo;
    private JTextField domainPathField;
    private JTextField hostField;
    private JTextField portField;
    ServerTypeActionListener serverTypeActionListener = null;
    InstanceSelectionListener instanceSelectionListener = null;
    WSInstantiatingIterator instantiatingIterator;
    private Vector listeners = new Vector();

    public ServerProperties() {
        this.serverTypeCombo = null;
        this.localInstancesCombo = null;
        this.domainPathField = null;
        this.hostField = null;
        this.portField = null;
    }

    public ServerProperties(JComboBox jComboBox, JComboBox jComboBox2, JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.serverTypeCombo = jComboBox;
        this.localInstancesCombo = jComboBox2;
        this.domainPathField = jTextField;
        this.hostField = jTextField2;
        this.portField = jTextField3;
    }

    public void setVariables(JComboBox jComboBox, JComboBox jComboBox2, JTextField jTextField, JTextField jTextField2, JTextField jTextField3, WSInstantiatingIterator wSInstantiatingIterator) {
        if (this.serverTypeCombo == null) {
            this.serverTypeCombo = jComboBox;
        }
        if (this.localInstancesCombo == null) {
            this.localInstancesCombo = jComboBox2;
        }
        if (this.domainPathField == null) {
            this.domainPathField = jTextField;
        }
        if (this.hostField == null) {
            this.hostField = jTextField2;
        }
        if (this.portField == null) {
            this.portField = jTextField3;
        }
        if (this.instantiatingIterator == null) {
            this.instantiatingIterator = wSInstantiatingIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getRegisteredDomains(String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return new String[0];
        }
        String string2 = "/properties/profileRegistry.xml";
        InputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(new File(string + string2));
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("profile")) continue;
                String string3 = node.getAttributes().getNamedItem("path").getNodeValue();
                vector.add(string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSecurityEnabled(String string) {
        block6: {
            boolean bl;
            File file = new File(string, "security.xml");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new NamespaceContext(){

                    public String getNamespaceURI(String string) {
                        if ("security".equals(string)) {
                            return "http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi";
                        }
                        return "";
                    }

                    public String getPrefix(String string) {
                        throw new UnsupportedOperationException("Not needed");
                    }

                    public Iterator getPrefixes(String string) {
                        throw new UnsupportedOperationException("Not needed");
                    }
                });
                String string2 = xPath.evaluate("/security:Security/@enabled", new InputSource(bufferedInputStream));
                bl = string2 != null && Boolean.parseBoolean(string2);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)bufferedInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                    break block6;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    LOGGER.log(Level.INFO, null, xPathExpressionException);
                }
            }
            ((InputStream)bufferedInputStream).close();
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellPort(String object) {
        Object object2;
        String[] stringArray = new File((String)object + "/nodes").list();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (String)object + "/nodes/" + stringArray[i] + "/serverindex.xml";
            if (!new File((String)object2).exists()) continue;
            object = object2;
            break;
        }
        InputStream inputStream = null;
        object2 = null;
        try {
            inputStream = new FileInputStream(new File((String)object));
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element element = object2.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("serverEntries")) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("specialEndpoints") || !node2.getAttributes().getNamedItem("endPointName").getNodeValue().equals("SOAP_CONNECTOR_ADDRESS")) continue;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        String string;
                        Node node3 = nodeList3.item(k);
                        if (!node3.getNodeName().equals("endPoint")) continue;
                        String string2 = string = node3.getAttributes().getNamedItem("port").getNodeValue();
                        return string2;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellAdminPort(String object) {
        Object object2;
        String[] stringArray = new File((String)object + "/nodes").list();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (String)object + "/nodes/" + stringArray[i] + "/serverindex.xml";
            if (!new File((String)object2).exists()) continue;
            object = object2;
            break;
        }
        InputStream inputStream = null;
        object2 = null;
        try {
            inputStream = new FileInputStream(new File((String)object));
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element element = object2.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("serverEntries")) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("specialEndpoints") || !node2.getAttributes().getNamedItem("endPointName").getNodeValue().equals("WC_adminhost")) continue;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        String string;
                        Node node3 = nodeList3.item(k);
                        if (!node3.getNodeName().equals("endPoint")) continue;
                        String string2 = string = node3.getAttributes().getNamedItem("port").getNodeValue();
                        return string2;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellDefaultHostPort(String object) {
        Object object2;
        String[] stringArray = new File((String)object + "/nodes").list();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (String)object + "/nodes/" + stringArray[i] + "/serverindex.xml";
            if (!new File((String)object2).exists()) continue;
            object = object2;
            break;
        }
        InputStream inputStream = null;
        object2 = null;
        try {
            inputStream = new FileInputStream(new File((String)object));
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element element = object2.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("serverEntries")) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("specialEndpoints") || !node2.getAttributes().getNamedItem("endPointName").getNodeValue().equals("WC_defaulthost")) continue;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        String string;
                        Node node3 = nodeList3.item(k);
                        if (!node3.getNodeName().equals("endPoint")) continue;
                        String string2 = string = node3.getAttributes().getNamedItem("port").getNodeValue();
                        return string2;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellHttpPort(String object) {
        Object object2;
        String[] stringArray = new File((String)object + "/nodes").list();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (String)object + "/nodes/" + stringArray[i] + "/serverindex.xml";
            if (!new File((String)object2).exists()) continue;
            object = object2;
            break;
        }
        InputStream inputStream = null;
        object2 = null;
        try {
            inputStream = new FileInputStream(new File((String)object));
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element element = object2.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("serverEntries")) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("specialEndpoints") || !node2.getAttributes().getNamedItem("endPointName").getNodeValue().equals("WC_defaulthost")) continue;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        String string;
                        Node node3 = nodeList3.item(k);
                        if (!node3.getNodeName().equals("endPoint")) continue;
                        String string2 = string = node3.getAttributes().getNamedItem("port").getNodeValue();
                        return string2;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return "";
    }

    public static String getConfigXmlPath(String string) {
        String[] stringArray = new File(string + "/nodes").list();
        String string2 = ServerProperties.getServerName(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = string + "/nodes/" + stringArray[i] + "/servers/" + string2 + "/server.xml";
            if (!new File(string3).exists()) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Config path: " + string3);
            }
            return string3;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerName(String object) {
        Object object2;
        String[] stringArray = new File((String)object + "/nodes").list();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (String)object + "/nodes/" + stringArray[i] + "/serverindex.xml";
            if (!new File((String)object2).exists()) continue;
            object = object2;
            break;
        }
        InputStream inputStream = null;
        object2 = null;
        try {
            inputStream = new FileInputStream(new File((String)object));
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element element = object2.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("serverEntries")) continue;
                String string = node.getAttributes().getNamedItem("serverName").getNodeValue();
                return string;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return "";
    }

    public static Vector getServerInstances(String string) {
        Vector<Instance> vector = new Vector<Instance>();
        String[] stringArray = ServerProperties.getRegisteredDomains(string);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i] + "/config/cells");
            String[] stringArray2 = file.list(new DirectoryFilter());
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = file.getAbsolutePath() + File.separator + stringArray2[j];
                boolean bl = ServerProperties.isSecurityEnabled(string2);
                String string3 = "localhost";
                String string4 = ServerProperties.getCellPort(string2);
                String string5 = ServerProperties.getCellAdminPort(string2);
                String string6 = ServerProperties.getCellAdminPort(string2);
                String string7 = ServerProperties.getServerName(string2);
                String string8 = ServerProperties.getConfigXmlPath(string2);
                String string9 = ServerProperties.getCellDefaultHostPort(string2);
                vector.add(new Instance(string7, string3, string4, stringArray[i], string8, string5, string6, string9, bl));
            }
        }
        return vector;
    }

    public static boolean isValidDomainRoot(String string) {
        String[] stringArray = new String[]{"config/cells", "etc/ws-security", "properties/soap.client.props", "properties/wsadmin.properties"};
        return ServerProperties.hasChildren(string, stringArray);
    }

    public static boolean hasChildren(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (new File(string + File.separator + stringArray[i]).exists()) continue;
            return false;
        }
        return true;
    }

    public ServerTypeActionListener getServerTypeActionListener() {
        if (this.serverTypeActionListener == null) {
            this.serverTypeActionListener = new ServerTypeActionListener();
        }
        return this.serverTypeActionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(changeListener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        this.fireChangeEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent changeEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)vector.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    public void updateInstancesList(String string) {
        this.localInstancesCombo.setModel(new InstancesModel(ServerProperties.getServerInstances(string)));
        this.updateInstanceInfo();
    }

    private void updateInstanceInfo() {
        Instance instance = (Instance)this.localInstancesCombo.getSelectedItem();
        if (instance != null) {
            this.domainPathField.setText(instance.getDomainPath());
            this.hostField.setText(instance.getHost());
            this.portField.setText(instance.getPort());
            if (this.instantiatingIterator != null) {
                this.instantiatingIterator.setHost(instance.getHost());
                this.instantiatingIterator.setPort(instance.getPort());
                this.instantiatingIterator.setAdminPort(instance.getAdminPort());
                this.instantiatingIterator.setConfigXmlPath(instance.getConfigXmlPath());
                this.instantiatingIterator.setDefaultHostPort(instance.getDefaultHostPort());
                this.instantiatingIterator.setDomainRoot(instance.getDomainPath());
                this.instantiatingIterator.setServerName(instance.getName());
            }
        }
    }

    public InstanceSelectionListener getInstanceSelectionListener() {
        if (this.instanceSelectionListener == null) {
            this.instanceSelectionListener = new InstanceSelectionListener();
        }
        return this.instanceSelectionListener;
    }

    public class InstanceSelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ServerProperties.this.updateInstanceInfo();
        }
    }

    public class KeyListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            ServerProperties.this.fireChangeEvent();
        }

        public void keyReleased(KeyEvent keyEvent) {
            ServerProperties.this.fireChangeEvent();
        }
    }

    public class ServerTypeActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ServerProperties.this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ServerProperties.class, (String)"TXT_ServerTypeLocal"))) {
                Instance instance = (Instance)ServerProperties.this.localInstancesCombo.getSelectedItem();
                if (instance == null) {
                    return;
                }
                ServerProperties.this.localInstancesCombo.setEnabled(true);
                ServerProperties.this.domainPathField.setEnabled(true);
                ServerProperties.this.domainPathField.setEditable(false);
                ServerProperties.this.hostField.setEnabled(true);
                ServerProperties.this.hostField.setEditable(false);
                ServerProperties.this.hostField.setText(instance.getHost());
                ServerProperties.this.portField.setEnabled(true);
                ServerProperties.this.portField.setEditable(false);
                ServerProperties.this.portField.setText(instance.getPort());
            } else {
                ServerProperties.this.localInstancesCombo.setEnabled(false);
                ServerProperties.this.domainPathField.setEnabled(false);
                ServerProperties.this.domainPathField.setEditable(false);
                ServerProperties.this.hostField.setEnabled(true);
                ServerProperties.this.hostField.setEditable(true);
                ServerProperties.this.portField.setEnabled(true);
                ServerProperties.this.portField.setEditable(true);
            }
        }
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file, String string) {
            return new File(file.getAbsolutePath() + File.separator + string).isDirectory();
        }
    }
}

