/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui.nodes;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.websphere6.ui.nodes.RefreshCookie;
import org.netbeans.modules.j2ee.websphere6.ui.nodes.WSDefaultModule;
import org.netbeans.modules.j2ee.websphere6.ui.nodes.WSDefaultModuleNode;
import org.netbeans.modules.j2ee.websphere6.ui.nodes.actions.RefreshAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WebModulesNode
extends AbstractNode {
    private static final Logger LOGGER = Logger.getLogger(WebModulesNode.class.getName());

    private WebModulesNode(WebModuleChildFactory webModuleChildFactory) {
        super(Children.create((ChildFactory)webModuleChildFactory, (boolean)true));
        this.setDisplayName(NbBundle.getMessage(WebModulesNode.class, (String)"LBL_WebApps"));
        this.getCookieSet().add((Node.Cookie)new RefreshEnterpriseModuleChildren(webModuleChildFactory));
    }

    public static WebModulesNode newInstance(Lookup lookup) {
        WebModuleChildFactory webModuleChildFactory = new WebModuleChildFactory(lookup);
        return new WebModulesNode(webModuleChildFactory);
    }

    public Image getIcon(int n) {
        return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_FOLDER);
    }

    public Image getOpenedIcon(int n) {
        return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_OPENED_FOLDER);
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(RefreshAction.class)};
    }

    private static class RefreshEnterpriseModuleChildren
    implements RefreshCookie {
        private final WebModuleChildFactory factory;

        RefreshEnterpriseModuleChildren(WebModuleChildFactory webModuleChildFactory) {
            this.factory = webModuleChildFactory;
        }

        public void refresh() {
            this.factory.refresh();
        }
    }

    private static class WebModule
    extends WSDefaultModule {
        private static final String PREFIX = "WebSphere:";
        private static final String NAME_ATTRIBUTE = "name";
        private static final String NAME_SUFFIX_1 = "_war";
        private static final String NAME_SUFFIX_2 = ".war";
        private String realName;

        public WebModule(TargetModuleID targetModuleID, boolean bl) {
            super(targetModuleID, bl);
        }

        public synchronized String getRealName() {
            if (this.realName == null) {
                TargetModuleID[] targetModuleIDArray = this.getModuleID().getChildTargetModuleID();
                if (targetModuleIDArray != null && targetModuleIDArray.length == 1) {
                    this.realName = this.constructName(targetModuleIDArray[0].getModuleID(), false);
                }
                this.realName = this.constructName(this.getModuleID().getModuleID(), true);
            }
            return this.realName;
        }

        protected String constructName(String string, boolean bl) {
            String string2 = string;
            if (string2.startsWith(PREFIX)) {
                String[] stringArray;
                string2 = string2.substring(PREFIX.length());
                for (String string3 : stringArray = string2.split(",")) {
                    String[] stringArray2 = string3.split("=");
                    if (stringArray2.length != 2 || !stringArray2[0].trim().equals(NAME_ATTRIBUTE)) continue;
                    string2 = stringArray2[1].trim();
                    if (!bl) {
                        if (string2.endsWith(NAME_SUFFIX_1)) {
                            return string2.substring(0, string2.length() - NAME_SUFFIX_1.length());
                        }
                        if (string2.endsWith(NAME_SUFFIX_2)) {
                            return string2.substring(0, string2.length() - NAME_SUFFIX_2.length());
                        }
                    }
                    return string2;
                }
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebModuleChildFactory
    extends ChildFactory<WebModule> {
        private final Lookup lookup;

        public WebModuleChildFactory(Lookup lookup) {
            this.lookup = lookup;
        }

        public void refresh() {
            this.refresh(false);
        }

        protected Node createNodeForKey(WebModule webModule) {
            return new WSDefaultModuleNode(ModuleType.WAR, webModule);
        }

        protected boolean createKeys(List<WebModule> list) {
            DeploymentManager deploymentManager = (DeploymentManager)this.lookup.lookup(DeploymentManager.class);
            Target target = (Target)this.lookup.lookup(Target.class);
            if (deploymentManager == null || target == null) {
                return true;
            }
            try {
                ArrayList<WebModule> arrayList = new ArrayList<WebModule>();
                HashSet<String> hashSet = new HashSet<String>();
                for (TargetModuleID targetModuleID : deploymentManager.getRunningModules(ModuleType.WAR, new Target[]{target})) {
                    arrayList.add(new WebModule(targetModuleID, true));
                    hashSet.add(targetModuleID.getModuleID());
                }
                for (TargetModuleID targetModuleID : deploymentManager.getAvailableModules(ModuleType.WAR, new Target[]{target})) {
                    if (hashSet.contains(targetModuleID.getModuleID())) continue;
                    arrayList.add(new WebModule(targetModuleID, false));
                }
                Collections.sort(arrayList, WSDefaultModule.MODULE_COMPARATOR);
                list.addAll(arrayList);
            }
            catch (TargetException targetException) {
                LOGGER.log(Level.INFO, null, targetException);
            }
            return true;
        }
    }
}

