/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui.nodes.editors;

import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class WSPasswordEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final Logger LOGGER = Logger.getLogger(WSPasswordEditor.class.getName());
    private String value = "";
    private PropertyEnv myPropertyEnv = null;

    public String getAsText() {
        LOGGER.log(Level.FINEST, "getAsText()");
        return this.value.replaceAll(".", "*");
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "setAsText(" + string + ")");
        }
        if (string != null) {
            this.value = string;
            this.firePropertyChange();
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.myPropertyEnv = propertyEnv;
    }

    public void setValue(Object object) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "setValue(" + object + ")");
        }
        if (object != null) {
            this.value = object.toString();
        }
    }

    public Object getValue() {
        LOGGER.log(Level.FINEST, "getValue()");
        return this.value;
    }

    public Component getInPlaceCustomEditor() {
        LOGGER.log(Level.FINEST, "getInPlaceCustomEditor()");
        JPasswordField jPasswordField = new JPasswordField(this.value);
        jPasswordField.setEchoChar('*');
        jPasswordField.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPasswordField.setMargin(new Insets(0, 0, 0, 0));
        jPasswordField.selectAll();
        jPasswordField.addKeyListener(new PasswordListener());
        return jPasswordField;
    }

    public boolean hasInPlaceCustomEditor() {
        LOGGER.log(Level.FINEST, "hasInPlaceCustomEditor()");
        return true;
    }

    public boolean supportsEditingTaggedValues() {
        LOGGER.log(Level.FINEST, "supportsEditingTaggedValues()");
        return false;
    }

    private class PasswordListener
    extends KeyAdapter {
        private PasswordListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "keyReleased(" + keyEvent + ")");
            }
            JPasswordField jPasswordField = (JPasswordField)keyEvent.getSource();
            WSPasswordEditor.this.value = new String(jPasswordField.getPassword());
            WSPasswordEditor.this.firePropertyChange();
            if (keyEvent.getKeyCode() == 10) {
                KeyEvent keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, 0L, 0, 27, '\uffff');
                KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchKeyEvent(keyEvent2);
            }
        }
    }
}

