/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.websphere6.WSVersion;
import org.netbeans.modules.j2ee.websphere6.ui.wizard.WSInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServerLocationPanel
extends JPanel
implements WizardDescriptor.Panel {
    private static final Logger LOGGER = Logger.getLogger(ServerLocationPanel.class.getName());
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private transient WizardDescriptor wizardDescriptor;
    private transient WSInstantiatingIterator instantiatingIterator;
    private JButton locationBrowseButton;
    private JLabel locationLabel;
    private JTextField locationField;
    private JPanel formattingPanel;
    private JFileChooser fileChooser = new JFileChooser();
    private Vector listeners = new Vector();

    public ServerLocationPanel(String[] stringArray, int n, ChangeListener changeListener, WSInstantiatingIterator wSInstantiatingIterator) {
        this.instantiatingIterator = wSInstantiatingIterator;
        this.putClientProperty("WizardPanel_contentData", stringArray);
        this.putClientProperty("WizardPanel_contentSelectedIndex", n);
        this.addChangeListener(changeListener);
        this.setName(stringArray[n]);
        this.init();
    }

    public HelpCtx getHelp() {
        return new HelpCtx("j2eeplugins_registering_app_server_websphere");
    }

    public Component getComponent() {
        return this;
    }

    public boolean isValid() {
        this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        if (!ServerLocationPanel.isValidServerRoot(this.locationField.getText())) {
            WSVersion wSVersion = this.instantiatingIterator.getVersion();
            String string = "";
            switch (wSVersion) {
                case VERSION_60: {
                    string = "V6.0";
                    break;
                }
                case VERSION_61: {
                    string = "V6.1";
                }
            }
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ServerLocationPanel.class, (String)"ERR_INVALID_SERVER_ROOT", (Object)string));
            return false;
        }
        this.instantiatingIterator.setServerRoot(this.locationField.getText());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String string;
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationBrowseButton = new JButton();
        this.formattingPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.locationLabel.setText(NbBundle.getMessage(ServerLocationPanel.class, (String)"LBL_SERVER_LOCATION"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(ServerLocationPanel.class, (String)"MNE_SERVER_LOCATION").charAt(0));
        this.locationLabel.setLabelFor(this.locationField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.locationLabel, gridBagConstraints);
        this.locationField.addKeyListener(new LocationKeyListener());
        if ((System.getProperty("websphere.home") == null || System.getProperty("websphere.home").equals("")) && (string = System.getProperty("user.home")) != null) {
            try {
                File file = new File(string + File.separator + ".WASRegistry");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.length() <= 1 || !new File(string2).exists()) continue;
                        System.setProperty("websphere.home", string2);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
            }
        }
        if (System.getProperty("websphere.home") != null) {
            this.locationField.setText(System.getProperty("websphere.home"));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.locationField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/ui/wizard/Bundle").getString("TTL_Location"));
        this.locationField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/ui/wizard/Bundle").getString("MSG_Location"));
        this.add((Component)this.locationField, gridBagConstraints);
        this.locationBrowseButton.setText(NbBundle.getMessage(ServerLocationPanel.class, (String)"LBL_BROWSE_BUTTON"));
        this.locationBrowseButton.setMnemonic(79);
        this.locationBrowseButton.setDisplayedMnemonicIndex(2);
        this.locationBrowseButton.addActionListener(new BrowseActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.locationBrowseButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/ui/wizard/Bundle").getString("TTL_Browse"));
        this.locationBrowseButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/ui/wizard/Bundle").getString("MSG_Browse"));
        this.add((Component)this.locationBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.formattingPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/ui/wizard/Bundle").getString("MSG_ServerLocationPanelDescription"));
    }

    private void showFileChooser() {
        this.fileChooser.setFileFilter(new DirectoryFileFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(1);
        File file = new File(this.locationField.getText());
        if (file.exists() && file.isDirectory()) {
            this.fileChooser.setCurrentDirectory(file.getParentFile());
            this.fileChooser.setSelectedFile(file);
        }
        if (this.fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.locationField.setText(this.fileChooser.getSelectedFile().getPath());
            this.fireChangeEvent();
        }
    }

    private static boolean isValidServerRoot(String string) {
        String string2 = "derby";
        String string3 = "plugins/com.ibm.ws.runtime_6.1.0.jar";
        if (new File(string + File.separator + "cloudscape").exists()) {
            string2 = "cloudscape";
            string3 = "lib/wjmxapp.jar";
        }
        String[] stringArray = new String[]{"bin", string2, "profiles", "properties/wsadmin.properties", "lib/j2ee.jar", string3};
        return ServerLocationPanel.hasChildren(string, stringArray);
    }

    private static boolean hasChildren(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (new File(string + File.separator + stringArray[i]).exists()) continue;
            return false;
        }
        return true;
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
    }

    public void storeSettings(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(changeListener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        this.fireChangeEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent changeEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)vector.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    private static class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        public boolean accept(File file) {
            return file.exists() && file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(ServerLocationPanel.class, (String)"DIRECTORIES_FILTER_NAME");
        }
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServerLocationPanel.this.showFileChooser();
        }
    }

    private class LocationKeyListener
    extends KeyAdapter {
        private LocationKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            ServerLocationPanel.this.fireChangeEvent();
        }

        public void keyReleased(KeyEvent keyEvent) {
            ServerLocationPanel.this.fireChangeEvent();
        }
    }
}

