/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class WSTailer
extends Thread {
    private static final int delay = 1000;
    private static Map isIOPanelOpen = Collections.synchronizedMap(new HashMap(2, 1.0f));
    private File file;
    private InputStream inputStream;
    private InputOutput io;

    public WSTailer(File file, String string) {
        this.file = file;
        this.io = IOProvider.getDefault().getIO(string, false);
    }

    public WSTailer(InputStream inputStream, String string) {
        this.inputStream = inputStream;
        this.io = IOProvider.getDefault().getIO(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (isIOPanelOpen.containsKey(this.io)) {
            this.io.select();
            return;
        }
        isIOPanelOpen.put(this.io, new Object());
        try {
            if (this.io.isClosed()) {
                this.io.getOut().reset();
            }
            this.io.select();
            if (this.file != null) {
                while (this.inputStream == null) {
                    try {
                        this.inputStream = new FileInputStream(this.file);
                    }
                    catch (IOException iOException) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
            while (!this.io.isClosed()) {
                while (bufferedReader.ready()) {
                    String string = bufferedReader.readLine();
                    if (string == null) continue;
                    this.io.getOut().println(string);
                    this.io.getOut().flush();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.WARNING, null, fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.WARNING, null, iOException);
        }
        finally {
            try {
                isIOPanelOpen.remove(this.io);
                this.inputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
    }
}

