/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.deploy;

import com.nokia.phone.deploy.CONA;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer {
    private boolean connected = false;

    public Deployer() {
        this.openConnectionLayer();
        if (!this.connected) {
            // empty if block
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isPCSuiteInstalled() {
        return CONA.getInstance().isConnAPIDllFound();
    }

    public boolean isOSSupportsDeployment() {
        return CONA.getInstance().isOSSupportsDeployment();
    }

    public void openConnectionLayer() {
        if (CONA.getInstance().isConnAPIDllFound() && CONA.getInstance().isConnJNIDllFound() && !this.connected) {
            this.connected = CONA.getInstance().connect();
        }
    }

    public void closeConnectionLayer() {
        try {
            Thread.sleep(3050L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connected) {
            boolean bl = CONA.getInstance().disconnect();
            if (!bl) {
                System.err.println("Failed to close service layer");
            }
            this.connected = !bl;
        }
    }

    public List<String> getTerminals() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.connected) {
            this.openConnectionLayer();
        }
        if (!this.connected) {
            System.err.println("Connection opening failed, could not get terminal list.");
            return arrayList;
        }
        this.addDevicesToList(CONA.getInstance().getDevices(8), arrayList);
        this.addDevicesToList(CONA.getInstance().getDevices(2), arrayList);
        this.addDevicesToList(CONA.getInstance().getDevices(4), arrayList);
        this.addDevicesToList(CONA.getInstance().getDevices(16), arrayList);
        return arrayList;
    }

    public String getConnectionType(String string) {
        if (!this.connected) {
            this.openConnectionLayer();
        }
        int n = this.getID(string);
        return CONA.getInstance().getDeviceType(n);
    }

    public List<String> deployToAllTerminals(File file, File file2) {
        List<String> list = this.getTerminals();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            try {
                boolean bl = this.deploy(file, file2, string);
                if (bl) {
                    System.out.println("Deployment succeeded!");
                    continue;
                }
                arrayList.add(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
                arrayList.add(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public boolean deploy(File file, File file2, String string) throws IOException, UnsatisfiedLinkError {
        if (!CONA.getInstance().isConnAPIDllFound()) {
            throw new UnsatisfiedLinkError("Failed to open ConnAPI.dll");
        }
        if (!CONA.getInstance().isConnJNIDllFound()) {
            throw new UnsatisfiedLinkError("Failed to open ConnJNI.dll");
        }
        if (!this.connected) {
            this.openConnectionLayer();
            if (!this.connected) {
                System.err.println("Failed to open service layer");
                return false;
            }
            System.out.println("Service layer opened");
        }
        int n = this.getID(string);
        if (!file.exists()) {
            throw new IOException("JAD file not found:" + file.getAbsolutePath());
        }
        if (!file2.exists()) {
            throw new IOException("JAR file not found:" + file2.getAbsolutePath());
        }
        if (n != -1) {
            return this.synchronizedDeploy(file, file2, n);
        }
        System.err.println("Failed to find destination device:" + string);
        return false;
    }

    private boolean openConnection(int n) {
        boolean bl = CONA.getInstance().openFileSystem(n);
        return bl;
    }

    private boolean closeConnection() {
        return CONA.getInstance().closeFileSystem();
    }

    private void addDevicesToList(String string, List<String> list) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
    }

    private int getID(String string) {
        String string2 = string.substring(string.indexOf("(ID:") + 4, string.indexOf(")")).trim();
        return Integer.parseInt(string2);
    }

    private boolean synchronizedDeploy(File file, File file2, int n) {
        boolean bl = true;
        String string = file2.getParentFile().getAbsolutePath();
        String string2 = file.getName();
        String string3 = file2.getName();
        boolean bl2 = this.openConnection(n);
        if (!bl2) {
            return false;
        }
        String string4 = string + "\\";
        bl = CONA.getInstance().installApplication(string4, string3, string2, 2, true);
        this.closeConnection();
        return true;
    }
}

