/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringUtils {
    public static boolean isPhpFile(FileObject fileObject) {
        return "text/x-php5".equals(fileObject.getMIMEType());
    }

    public static Program getRoot(CompilationInfo compilationInfo) {
        PHPParseResult pHPParseResult = RefactoringUtils.getParseResult(compilationInfo);
        return pHPParseResult != null ? pHPParseResult.getProgram() : null;
    }

    public static PHPParseResult getParseResult(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-php5", 0);
        return (PHPParseResult)parserResult;
    }

    public static Source getSource(Document document) {
        Source source = Source.forDocument((Document)document);
        return source;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(WhereUsedSupport.ResultElement resultElement) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)resultElement.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return RefactoringUtils.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static String htmlize(String string) {
        try {
            return XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            Exceptions.printStackTrace((Throwable)charConversionException);
            return string;
        }
    }

    public static String getHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)PHPTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-php5"));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String string2 = token.id().name();
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
            if (attributeSet == null) {
                string2 = token.id().primaryCategory();
                if (string2 == null) {
                    string2 = "whitespace";
                }
                attributeSet = fontColorSettings.getTokenFontColors(string2);
            }
            String string3 = RefactoringUtils.htmlize(((Object)token.text()).toString());
            stringBuffer.append(RefactoringUtils.color(string3, attributeSet));
        }
        return stringBuffer.toString();
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuffer.insert(0, "<s>");
            stringBuffer.append("</s>");
        }
        stringBuffer.insert(0, "<font color=" + RefactoringUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fileObject) {
        FileObject fileObject2;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null && (fileObject2 = classPath.findOwnerRoot(fileObject)) != null) {
            return fileObject.equals(fileObject2);
        }
        return false;
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RefactoringUtils.isPhpFile(fileObject) && RefactoringUtils.isFileInOpenProject(fileObject) && RefactoringUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static String getPackageName(URL uRL) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        String string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return RefactoringUtils.getPackageName(fileObject);
                }
                String string2 = RefactoringUtils.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + string;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    public static FileObject getOrCreateFolder(URL uRL) throws IOException {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                return fileObject;
            }
            File file = new File(uRL.toURI());
            fileObject = FileUtil.createFolder((File)file);
            return fileObject;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... classPath) {
        Project project;
        FileObject fileObject2;
        assert (((FileObject[])classPath).length > 0);
        HashSet<URL> hashSet = new HashSet<URL>();
        for (FileObject fileObject2 : classPath) {
            project = null;
            if (fileObject2 != null) {
                project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            }
            if (project != null) {
                URL uRL = URLMapper.findURL((FileObject)ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source").findOwnerRoot(fileObject2), (int)0);
                hashSet.addAll(SourceUtils.getDependentRoots((URL)uRL));
                for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("generic")) {
                    hashSet.add(URLMapper.findURL((FileObject)sourceGroup.getRootFolder(), (int)0));
                }
                continue;
            }
            for (SourceGroup[] sourceGroupArray : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject fileObject3 : sourceGroupArray.getRoots()) {
                    hashSet.add(URLMapper.findURL((FileObject)fileObject3, (int)0));
                }
            }
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
        ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath4 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/boot") : classPath3;
        fileObject2 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/compile") : classPath3;
        project = ClasspathInfo.create((ClassPath)classPath4, (ClassPath)fileObject2, (ClassPath)classPath2);
        return project;
    }

    public static boolean isOutsidePhp(Lookup lookup, FileObject fileObject) {
        EditorCookie editorCookie;
        if (RefactoringUtils.isPhpFile(fileObject) && RefactoringUtils.isFromEditor(editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
            Document document = jEditorPane.getDocument();
            if (!(document instanceof BaseDocument)) {
                return true;
            }
            int n = jEditorPane.getCaretPosition();
            if (LexUtilities.getToken((BaseDocument)((BaseDocument)document), (int)n) == null) {
                return true;
            }
        }
        return false;
    }

    static boolean isFromEditor(EditorCookie editorCookie) {
        TopComponent topComponent;
        return editorCookie != null && editorCookie.getOpenedPanes() != null && (topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static List<ASTNode> underCaret(CompilationInfo compilationInfo, final int n) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Result
        extends Error {
            private Stack<ASTNode> result;

            public Result(Stack<ASTNode> stack) {
                this.result = stack;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
        try {
            new DefaultVisitor(){
                private Stack<ASTNode> s = new Stack();

                public void scan(ASTNode aSTNode) {
                    if (aSTNode == null) {
                        return;
                    }
                    if (aSTNode.getStartOffset() <= n && n <= aSTNode.getEndOffset()) {
                        this.s.push(aSTNode);
                        super.scan(aSTNode);
                        throw new Result(this.s);
                    }
                }
            }.scan((ASTNode)RefactoringUtils.getRoot(compilationInfo));
        }
        catch (Result result) {
            return new LinkedList<ASTNode>(result.result);
        }
        return Collections.emptyList();
    }

    public static boolean isQuoted(String string) {
        return !(string.length() < 2 || !string.startsWith("\"") && !string.startsWith("'") || !string.endsWith("\"") && !string.endsWith("'"));
    }

    public static String dequote(String string) {
        assert (RefactoringUtils.isQuoted(string));
        return string.substring(1, string.length() - 1);
    }

    public static FileObject resolveInclude(CompilationInfo compilationInfo, Include include) {
        Scalar scalar;
        Expression expression = include.getExpression();
        if (expression instanceof ParenthesisExpression) {
            expression = ((ParenthesisExpression)expression).getExpression();
        }
        if (expression instanceof Scalar && Scalar.Type.STRING == (scalar = (Scalar)expression).getScalarType()) {
            String string = scalar.getStringValue();
            string = string.length() >= 2 ? string.substring(1, string.length() - 1) : string;
            return RefactoringUtils.resolveRelativeFile(compilationInfo, string);
        }
        return null;
    }

    private static FileObject resolveRelativeFile(CompilationInfo compilationInfo, String string) {
        PhpSourcePath phpSourcePath = null;
        Project project = FileOwnerQuery.getOwner((FileObject)compilationInfo.getFileObject());
        if (project != null) {
            phpSourcePath = (PhpSourcePath)project.getLookup().lookup(PhpSourcePath.class);
        }
        while (true) {
            FileObject fileObject = phpSourcePath != null ? PhpSourcePath.resolveFile((FileObject)compilationInfo.getFileObject().getParent(), (String)string) : compilationInfo.getFileObject().getParent().getFileObject(string);
            if (fileObject != null) {
                return fileObject;
            }
            int n = string.indexOf(47);
            if (n == -1) break;
            string = string.substring(n + 1);
        }
        return null;
    }

    public static FileObject getFile(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            DataObject dataObject = (DataObject)object;
            return dataObject.getPrimaryFile();
        }
        return null;
    }
}

