/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Collection;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedTokenList<T extends TokenId>
extends FlyOffsetGapList<TokenOrEmbedding<T>>
implements MutableTokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    public static final EmbeddedTokenList<TokenId> NO_DEFAULT_EMBEDDING = new EmbeddedTokenList(null, null, null);
    private EmbeddingContainer<?> embeddingContainer;
    private final LanguageEmbedding<T> embedding;
    private final LanguagePath languagePath;
    private LAState laState;
    private EmbeddedTokenList<?> nextEmbeddedTokenList;
    public EmbeddedJoinInfo joinInfo;

    public EmbeddedTokenList(EmbeddingContainer<?> embeddingContainer, LanguagePath languagePath, LanguageEmbedding<T> languageEmbedding) {
        super(1);
        this.embeddingContainer = embeddingContainer;
        this.languagePath = languagePath;
        this.embedding = languageEmbedding;
        if (embeddingContainer != null) {
            this.initLAState();
        }
    }

    public void initAllTokens() {
        assert (!this.embedding.joinSections()) : "Cannot init all tokens since ETL joins sections\n" + this + '\n' + this.dumpRelatedTLL();
        LexerInputOperation<T> lexerInputOperation = this.createLexerInputOperation(0, this.startOffset(), null);
        AbstractToken<T> abstractToken = lexerInputOperation.nextToken();
        while (abstractToken != null) {
            this.addToken(abstractToken, lexerInputOperation);
            abstractToken = lexerInputOperation.nextToken();
        }
        lexerInputOperation.release();
        lexerInputOperation = null;
        this.trimStorageToSize();
    }

    private void initLAState() {
        this.laState = this.modCount() != -1 || testing ? LAState.empty() : null;
    }

    public JoinTokenList<T> joinTokenList() {
        if (this.joinInfo != null) {
            TokenListList tokenListList = this.rootTokenList().tokenHierarchyOperation().existingTokenListList(this.languagePath);
            int n = tokenListList.findIndex(this.startOffset());
            int n2 = n - this.joinInfo.tokenListIndex();
            JoinTokenList joinTokenList = new JoinTokenList(tokenListList, this.joinInfo.base, n2);
            joinTokenList.setActiveTokenListIndex(n - n2);
            return joinTokenList;
        }
        return null;
    }

    public void addToken(AbstractToken<T> abstractToken) {
        if (!abstractToken.isFlyweight()) {
            abstractToken.setTokenList(this);
        }
        this.updateElementOffsetAdd(abstractToken);
        this.add(abstractToken);
    }

    public void addToken(AbstractToken<T> abstractToken, LexerInputOperation<T> lexerInputOperation) {
        this.addToken(abstractToken);
        if (this.laState != null) {
            this.laState = this.laState.add(lexerInputOperation.lookahead(), lexerInputOperation.lexerState());
        }
    }

    public void addToken(AbstractToken<T> abstractToken, int n, Object object) {
        this.addToken(abstractToken);
        if (this.laState != null) {
            this.laState = this.laState.add(n, object);
        }
    }

    public void trimStorageToSize() {
        this.trimToSize();
        if (this.laState != null) {
            this.laState.trimToSize();
        }
    }

    public EmbeddedTokenList<?> nextEmbeddedTokenList() {
        return this.nextEmbeddedTokenList;
    }

    void setNextEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList) {
        this.nextEmbeddedTokenList = embeddedTokenList;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public LanguageEmbedding embedding() {
        return this.embedding;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    public int joinTokenCount() {
        int n = this.tokenCountCurrent();
        if (n > 0 && this.joinInfo.joinTokenLastPartShift() > 0) {
            --n;
        }
        return n;
    }

    public boolean joinBackward() {
        if (this.tokenCountCurrent() > 0) {
            AbstractToken<T> abstractToken = this.tokenOrEmbeddingUnsync(0).token();
            return abstractToken.getClass() == PartToken.class && ((PartToken)abstractToken).partTokenIndex() > 0;
        }
        return this.joinInfo.joinTokenLastPartShift() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        TokenList<?> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            return n < this.size() ? (TokenOrEmbedding)this.get(n) : null;
        }
    }

    @Override
    public int lookahead(int n) {
        return this.laState != null ? this.laState.lookahead(n) : -1;
    }

    @Override
    public Object state(int n) {
        return this.laState != null ? this.laState.state(n) : null;
    }

    @Override
    public int tokenOffsetByIndex(int n) {
        return this.elementOffset(n);
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        if (abstractToken.getClass() == JoinToken.class) {
            return abstractToken.offset(null);
        }
        int n = abstractToken.rawOffset();
        int n2 = n < this.offsetGapStart() ? n : n - this.offsetGapLength();
        return this.startOffset() + n2;
    }

    @Override
    public int[] tokenIndex(int n) {
        return LexerUtilsConstants.tokenIndexBinSearch(this, n, this.tokenCountCurrent());
    }

    @Override
    public int modCount() {
        return this.embeddingContainer.cachedModCount();
    }

    @Override
    public int startOffset() {
        return this.embeddingContainer.branchTokenStartOffset() + this.embedding.startSkipLength();
    }

    @Override
    public int endOffset() {
        return this.embeddingContainer.branchTokenStartOffset() + this.embeddingContainer.token().length() - this.embedding.endSkipLength();
    }

    public int textLength() {
        return this.embeddingContainer.token().length() - this.embedding.startSkipLength() - this.embedding.endSkipLength();
    }

    @Override
    public boolean isRemoved() {
        return this.embeddingContainer.isRemoved();
    }

    @Override
    public TokenList<?> rootTokenList() {
        return this.embeddingContainer.rootTokenList();
    }

    @Override
    public CharSequence inputSourceText() {
        return this.rootTokenList().inputSourceText();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.rootTokenList().tokenHierarchyOperation();
    }

    protected int elementRawOffset(TokenOrEmbedding<T> tokenOrEmbedding) {
        return tokenOrEmbedding.token().rawOffset();
    }

    protected void setElementRawOffset(TokenOrEmbedding<T> tokenOrEmbedding, int n) {
        tokenOrEmbedding.token().setRawOffset(n);
    }

    protected boolean isElementFlyweight(TokenOrEmbedding<T> tokenOrEmbedding) {
        return tokenOrEmbedding.token().isFlyweight();
    }

    protected int elementLength(TokenOrEmbedding<T> tokenOrEmbedding) {
        return tokenOrEmbedding.token().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TokenList<?> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            TextToken textToken = ((TextToken)abstractToken).createCopy(this, this.offset2Raw(n2));
            this.set(n, textToken);
            return textToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        TokenList<?> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            this.set(n, embeddingContainer);
        }
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.rootTokenList().inputAttributes();
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbeddingUnsync(int n) {
        return (TokenOrEmbedding)this.get(n);
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int n, int n2, Object object) {
        int n3 = this.endOffset();
        assert (n2 <= n3) : "Invalid relexOffset=" + n2 + " > endOffset()=" + n3;
        return new TextLexerInputOperation(this, n, object, n2, n3);
    }

    @Override
    public boolean isFullyLexed() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceTokens(TokenListChange<T> tokenListChange, TokenHierarchyEventInfo tokenHierarchyEventInfo, boolean bl) {
        AbstractToken abstractToken;
        Object[] objectArray;
        int n = tokenListChange.index();
        int n2 = tokenListChange.removedTokenCount();
        int n3 = this.rootTokenList().modCount();
        AbstractToken abstractToken2 = null;
        if (n2 > 0) {
            void tokenOrEmbedding;
            objectArray = new TokenOrEmbedding[n2];
            this.copyElements(n, n + n2, objectArray, 0);
            abstractToken2 = objectArray[0].token();
            int n4 = 0;
            if (!this.embeddingContainer.isRemoved() && this.embeddingContainer.branchTokenStartOffset() >= tokenHierarchyEventInfo.modOffset()) {
                n4 -= tokenHierarchyEventInfo.diffLength();
            }
            boolean i = false;
            while (tokenOrEmbedding < n2) {
                abstractToken = objectArray[tokenOrEmbedding];
                AbstractToken abstractToken3 = abstractToken.token();
                if (!abstractToken3.isFlyweight()) {
                    this.updateElementOffsetRemove(abstractToken3);
                    if (n4 != 0) {
                        abstractToken3.setRawOffset(abstractToken3.rawOffset() + n4);
                    }
                    abstractToken3.setTokenList(null);
                    EmbeddingContainer embeddingContainer = abstractToken.embedding();
                    if (embeddingContainer != null) {
                        assert (embeddingContainer.cachedModCount() != n3) : "ModCount already updated";
                        embeddingContainer.markRemoved(abstractToken3.rawOffset());
                    }
                }
                ++tokenOrEmbedding;
            }
            this.remove(n, n2);
            this.laState.remove(n, n2);
            tokenListChange.setRemovedTokens((TokenOrEmbedding<T>[])objectArray);
        } else {
            tokenListChange.setRemovedTokensEmpty();
        }
        if (bl) {
            int n5 = this.startOffset();
            if (this.offsetGapStart() != tokenListChange.offset() - n5) {
                this.moveOffsetGap(tokenListChange.offset() - n5, tokenListChange.index());
            }
            this.updateOffsetGapLength(-tokenHierarchyEventInfo.diffLength());
        }
        if ((objectArray = tokenListChange.addedTokenOrEmbeddings()) != null) {
            for (TokenOrEmbedding tokenOrEmbedding : objectArray) {
                abstractToken = tokenOrEmbedding.token();
                if (!abstractToken.isFlyweight()) {
                    abstractToken.setTokenList(this);
                }
                this.updateElementOffsetAdd(abstractToken);
            }
            this.addAll(n, (Collection)objectArray);
            this.laState = this.laState.addAll(n, tokenListChange.laState());
            tokenListChange.syncAddedTokenCount();
            if (n2 == 1 && objectArray.size() == 1) {
                AbstractToken<T> abstractToken4 = tokenListChange.addedTokenOrEmbeddings().get(0).token();
                if (abstractToken2.id() == abstractToken4.id() && abstractToken2.partType() == abstractToken4.partType()) {
                    tokenListChange.markBoundsChange();
                }
            }
        }
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public EmbeddingContainer<?> embeddingContainer() {
        return this.embeddingContainer;
    }

    public void setEmbeddingContainer(EmbeddingContainer<?> embeddingContainer) {
        this.embeddingContainer = embeddingContainer;
    }

    public StringBuilder dumpInfo(StringBuilder stringBuilder) {
        EmbeddingContainer<?> embeddingContainer;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(50);
        }
        if ((embeddingContainer = this.embeddingContainer) != null && embeddingContainer.isRemoved()) {
            stringBuilder.append("REMOVED-");
        }
        stringBuilder.append("ETL");
        if (this.embedding.joinSections()) {
            stringBuilder.append('j');
        }
        stringBuilder.append('<').append(this.startOffset());
        stringBuilder.append(",").append(this.endOffset());
        stringBuilder.append("> TC=").append(this.tokenCountCurrent());
        if (this.joinInfo != null) {
            stringBuilder.append("(").append(this.joinTokenCount()).append(')');
            stringBuilder.append(" JI:");
            this.joinInfo.dumpInfo(stringBuilder);
        }
        stringBuilder.append(", IHC=").append(System.identityHashCode(this));
        return stringBuilder;
    }

    private String dumpRelatedTLL() {
        TokenListList tokenListList = this.rootTokenList().tokenHierarchyOperation().existingTokenListList(this.languagePath);
        return tokenListList != null ? tokenListList.toString() : "<No TokenListList for " + this.languagePath.mimePath() + ">";
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        this.dumpInfo(stringBuilder);
        LexerUtilsConstants.appendTokenList(stringBuilder, this);
        return stringBuilder.toString();
    }
}

