/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerUtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenIdSet<T extends TokenId>
extends AbstractSet<T> {
    final T[] indexedIds;
    private int size = -1;

    public static int findMaxOrdinal(Collection<? extends TokenId> collection) {
        int n = -1;
        for (TokenId tokenId : collection) {
            n = Math.max(n, tokenId.ordinal());
        }
        return n;
    }

    public static <T extends TokenId> void checkIdsFromLanguage(Collection<T> collection, Set<T> set) {
        for (TokenId tokenId : collection) {
            if (tokenId == null || set.contains(tokenId)) continue;
            throw new IllegalArgumentException(tokenId + "not contained in " + set);
        }
    }

    public TokenIdSet(Collection<T> collection, int n, boolean bl) {
        this.indexedIds = this.allocateIds(n + 1);
        if (collection != null) {
            for (TokenId tokenId : collection) {
                if (tokenId == null) continue;
                if (bl && this.indexedIds[tokenId.ordinal()] != null) {
                    throw new IllegalStateException(tokenId + " has duplicate ordinal with " + this.indexedIds[tokenId.ordinal()]);
                }
                this.indexedIds[tokenId.ordinal()] = tokenId;
            }
        }
    }

    private T[] allocateIds(int n) {
        return new TokenId[n];
    }

    @Override
    public boolean add(T t) {
        T t2 = this.indexedIds[t.ordinal()];
        this.indexedIds[t.ordinal()] = t;
        this.size = -1;
        return t2 != null;
    }

    @Override
    public boolean remove(T t) {
        T t2 = this.indexedIds[t.ordinal()];
        this.indexedIds[t.ordinal()] = null;
        this.size = -1;
        return t2 != null;
    }

    public T[] indexedIds() {
        return this.indexedIds;
    }

    @Override
    public int size() {
        int n = this.size;
        if (n < 0) {
            n = 0;
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            this.size = n;
        }
        return n;
    }

    @Override
    public Iterator<T> iterator() {
        return new SkipNullsIterator();
    }

    public boolean containsTokenId(TokenId tokenId) {
        int n = tokenId.ordinal();
        return n >= 0 && n < this.indexedIds.length && this.indexedIds[n] == tokenId;
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof TokenId ? this.containsTokenId((TokenId)object) : false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{\n");
        for (TokenId tokenId : this) {
            stringBuilder.append("    ");
            stringBuilder.append(LexerUtilsConstants.idToString(tokenId));
            stringBuilder.append('\n');
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SkipNullsIterator
    implements Iterator<T> {
        private int index;
        private int lastRetIndex = -1;

        SkipNullsIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < TokenIdSet.this.indexedIds.length) {
                if (TokenIdSet.this.indexedIds[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public T next() {
            while (this.index < TokenIdSet.this.indexedIds.length) {
                Object t;
                if ((t = TokenIdSet.this.indexedIds[this.index++]) == null) continue;
                this.lastRetIndex = this.index - 1;
                return t;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastRetIndex < 0) {
                throw new IllegalStateException();
            }
            TokenIdSet.this.indexedIds[this.lastRetIndex] = null;
            TokenIdSet.this.size = -1;
        }
    }
}

