/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.inc.JoinTokenListChange;
import org.netbeans.lib.lexer.inc.MutableJoinTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.inc.TokenListChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TokenListListUpdate<T extends TokenId> {
    final TokenListList<T> tokenListList;
    int modTokenListIndex;
    int removedTokenListCount;
    private EmbeddedTokenList<T>[] removedTokenLists;
    List<EmbeddedTokenList<T>> addedTokenLists;

    TokenListListUpdate(TokenListList<T> tokenListList) {
        this.tokenListList = tokenListList;
        this.modTokenListIndex = -1;
    }

    public boolean isTokenListsMod() {
        return this.removedTokenListCount != 0 || this.addedTokenLists.size() > 0;
    }

    public int tokenListCountDiff() {
        return this.addedTokenLists.size() - this.removedTokenListCount;
    }

    public int addedTokenListCount() {
        return this.addedTokenLists.size();
    }

    public EmbeddedTokenList<T> afterUpdateTokenList(JoinTokenList<T> joinTokenList, int n) {
        EmbeddedTokenList<T> embeddedTokenList;
        if (n < this.modTokenListIndex) {
            embeddedTokenList = joinTokenList.tokenList(n);
            embeddedTokenList.embeddingContainer().updateStatusUnsync();
        } else if (n < this.modTokenListIndex + this.addedTokenLists.size()) {
            embeddedTokenList = this.addedTokenLists.get(n - this.modTokenListIndex);
        } else {
            embeddedTokenList = joinTokenList.tokenList(n + this.removedTokenListCount - this.addedTokenLists.size());
            embeddedTokenList.embeddingContainer().updateStatusUnsync();
        }
        return embeddedTokenList;
    }

    protected int afterUpdateTokenListCount(JoinTokenList<T> joinTokenList) {
        return joinTokenList.tokenListCount() - this.removedTokenListCount + this.addedTokenLists.size();
    }

    void markChangedMember(EmbeddedTokenList<T> embeddedTokenList) {
        assert (this.modTokenListIndex == -1);
        this.modTokenListIndex = this.tokenListList.findIndex(embeddedTokenList.startOffset());
        assert (this.tokenListList.get(this.modTokenListIndex) == embeddedTokenList) : "changedTokenList at index " + this.modTokenListIndex + "; TokenListList:\n" + this.tokenListList;
    }

    void markChageBetween(int n) {
        assert (this.modTokenListIndex == -1);
        this.modTokenListIndex = this.tokenListList.findIndex(n);
    }

    void markRemovedMember(EmbeddedTokenList<T> embeddedTokenList, TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        EmbeddedTokenList<T> embeddedTokenList2;
        boolean bl;
        embeddedTokenList.embeddingContainer().updateStatus();
        if (this.modTokenListIndex == -1) {
            assert (this.removedTokenListCount == 0);
            bl = true;
            this.modTokenListIndex = this.tokenListList.findIndexDuringUpdate(embeddedTokenList, tokenHierarchyEventInfo);
            assert (this.modTokenListIndex >= 0) : "tokenListIndex=" + this.modTokenListIndex + " < 0";
        } else {
            bl = false;
        }
        if ((embeddedTokenList2 = this.tokenListList.getOrNull(this.modTokenListIndex + this.removedTokenListCount)) != embeddedTokenList) {
            int n = this.tokenListList.indexOf(embeddedTokenList);
            this.modTokenListIndex = this.tokenListList.findIndexDuringUpdate(embeddedTokenList, tokenHierarchyEventInfo);
            throw new IllegalStateException("Removing at tokenListIndex=" + this.modTokenListIndex + " but real tokenListIndex is " + n + " (indexWasMinusOne=" + bl + ").\n" + "Wishing to remove tokenList\n" + embeddedTokenList + "\nbut marked-for-remove tokenList is \n" + embeddedTokenList2 + "\nfrom tokenListList\n" + this.tokenListList + "\n\nModification description:\n" + tokenHierarchyEventInfo.modificationDescription(true));
        }
        ++this.removedTokenListCount;
    }

    void markAddedMember(EmbeddedTokenList<T> embeddedTokenList) {
        if (this.addedTokenLists == null) {
            if (this.modTokenListIndex == -1) {
                this.modTokenListIndex = this.tokenListList.findIndex(embeddedTokenList.startOffset());
                assert (this.modTokenListIndex >= 0) : "tokenListIndex=" + this.modTokenListIndex + " < 0";
            }
            this.addedTokenLists = new ArrayList<EmbeddedTokenList<T>>(4);
        }
        this.addedTokenLists.add(embeddedTokenList);
    }

    void replaceTokenLists(int n) {
        assert (this.removedTokenListCount > 0 || this.addedTokenLists != null);
        this.removedTokenLists = this.tokenListList.replace(this.modTokenListIndex + n, this.removedTokenListCount, this.addedTokenLists);
    }

    void collectRemovedEmbeddings(TokenHierarchyUpdate.UpdateItem<T> updateItem) {
        if (this.tokenListList.hasChildren() && this.removedTokenLists != null) {
            for (int i = 0; i < this.removedTokenLists.length; ++i) {
                updateItem.collectRemovedEmbeddings(this.removedTokenLists[i]);
            }
        }
    }

    void collectAddedEmbeddings(TokenHierarchyUpdate.UpdateItem<T> updateItem) {
        EmbeddedTokenList<T> embeddedTokenList;
        int n;
        boolean bl = false;
        for (n = 0; n < this.addedTokenLists.size(); ++n) {
            embeddedTokenList = this.addedTokenLists.get(n);
            bl |= embeddedTokenList.embedding().joinSections();
        }
        if (bl) {
            this.tokenListList.setJoinSections(true);
            JoinTokenList.create(this.tokenListList, 0, this.tokenListList.size());
        }
        for (n = 0; n < this.addedTokenLists.size(); ++n) {
            embeddedTokenList = this.addedTokenLists.get(n);
            if (!bl) {
                embeddedTokenList.initAllTokens();
            }
            if (!this.tokenListList.hasChildren()) continue;
            updateItem.collectAddedEmbeddings(embeddedTokenList, 0, embeddedTokenList.tokenCountCurrent());
        }
    }

    TokenListChange<T> createTokenListChange(EmbeddedTokenList<T> embeddedTokenList) {
        TokenListChange<T> tokenListChange;
        assert (embeddedTokenList != null);
        if (this.tokenListList.joinSections()) {
            MutableJoinTokenList<T> mutableJoinTokenList = MutableJoinTokenList.create(this.tokenListList, this.modTokenListIndex);
            tokenListChange = new JoinTokenListChange<T>(mutableJoinTokenList);
        } else {
            tokenListChange = new TokenListChange<T>(embeddedTokenList);
        }
        return tokenListChange;
    }

    TokenListChange<T> createJoinTokenListChange() {
        assert (this.tokenListList.joinSections());
        int n = Math.min(this.modTokenListIndex, this.tokenListList.size() - 1);
        MutableJoinTokenList<T> mutableJoinTokenList = MutableJoinTokenList.create(this.tokenListList, n);
        return new JoinTokenListChange<T>(mutableJoinTokenList);
    }

    public String toString() {
        return " modTokenListIndex=" + this.modTokenListIndex + "; Rem:" + this.removedTokenListCount + " Add:" + this.addedTokenLists.size() + " Size:" + this.tokenListList.size();
    }
}

