/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.common.CatalogWSDL;
import org.netbeans.modules.compapp.projects.common.ImplicitCatalogSupport;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;

public class Helper {
    private static final Logger sLogger = Logger.getLogger(Helper.class.getName());

    public static ProjectCatalogSupport createDefaultProjectCatalogSupport(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        return new DefaultProjectCatalogSupport(project, antProjectHelper, referenceHelper);
    }

    public static ProjectCatalogSupport createImplicitCatalogSupport(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        return new ImplicitCatalogSupport(project, antProjectHelper, referenceHelper);
    }

    public static boolean hasImplicitCatalogSupport(Project project) {
        assert (project != null);
        DefaultProjectCatalogSupport defaultProjectCatalogSupport = (DefaultProjectCatalogSupport)project.getLookup().lookup(DefaultProjectCatalogSupport.class);
        ImplicitCatalogSupport implicitCatalogSupport = (ImplicitCatalogSupport)((Object)project.getLookup().lookup(ImplicitCatalogSupport.class));
        return defaultProjectCatalogSupport != null && implicitCatalogSupport != null;
    }

    public static FileObject resolveImplicitReference(Project project, String string, CatalogWSDL.EntryType entryType) {
        FileObject fileObject = null;
        assert (project != null);
        ImplicitCatalogSupport implicitCatalogSupport = ImplicitCatalogSupport.getInstance(project);
        try {
            fileObject = implicitCatalogSupport.resolveImplicitReference(string, entryType);
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, exception.getMessage(), exception);
        }
        return fileObject;
    }

    public static FileObject resolveImplicitReference(FileObject fileObject, String string, CatalogWSDL.EntryType entryType) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return Helper.resolveImplicitReference(project, string, entryType);
    }
}

