/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;

class ActionsUtil {
    public static final ShortcutsManager SHORCUTS_MANAGER = new ShortcutsManager();
    public static HashMap<String, MessageFormat> pattern2format = new HashMap();

    ActionsUtil() {
    }

    public static Project[] getProjectsFromLookup(Lookup lookup, String string) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (DataObject dataObject : lookup.lookupAll(Project.class)) {
            hashSet.add(dataObject);
        }
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            FileObject fileObject = dataObject.getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) continue;
            hashSet.add(project);
        }
        DataObject dataObject = hashSet.toArray(new Project[hashSet.size()]);
        if (string != null) {
            for (Project project : dataObject) {
                if (ActionsUtil.commandSupported(project, string, lookup)) continue;
                return new Project[0];
            }
        }
        return dataObject;
    }

    public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            FileObject fileObject = dataObject.getPrimaryFile();
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project2 == null || !project2.equals(project)) continue;
            hashSet.add(fileObject);
        }
        FileObject[] fileObjectArray = new FileObject[hashSet.size()];
        hashSet.toArray(fileObjectArray);
        return fileObjectArray;
    }

    public static boolean commandSupported(Project project, String string, Lookup lookup) {
        List<String> list;
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        return actionProvider != null && (list = Arrays.asList(actionProvider.getSupportedActions())).contains(string) && (lookup == null || actionProvider.isActionEnabled(string, lookup));
    }

    public static String formatProjectSensitiveName(String string, Project[] projectArray) {
        if (projectArray == null || projectArray.length == 0) {
            return ActionsUtil.formatName(string, 0, null);
        }
        return ActionsUtil.formatName(string, projectArray.length, new Wrapper(projectArray[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatName(String string, int n, Object object) {
        MessageFormat messageFormat = null;
        Serializable serializable = pattern2format;
        synchronized (serializable) {
            messageFormat = pattern2format.get(string);
            if (messageFormat == null) {
                messageFormat = new MessageFormat(string);
                pattern2format.put(string, messageFormat);
            }
        }
        serializable = new StringBuffer();
        messageFormat.format(new Object[]{n, object == null ? "" : object.toString()}, (StringBuffer)serializable, (FieldPosition)null);
        return ((StringBuffer)serializable).toString();
    }

    public static class ShortcutsManager {
        Map<String, Object> shorcuts = new HashMap<String, Object>();
        HashMap<String, Set<Action>> actions = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAction(String string, Action action) {
            Object object = this;
            synchronized (object) {
                WeakSet weakSet = this.actions.get(string);
                if (weakSet == null) {
                    weakSet = new WeakSet();
                    this.actions.put(string, (Set<Action>)weakSet);
                }
                weakSet.add((Action)action);
            }
            object = this.getShortcut(string);
            if (object != null) {
                action.putValue("AcceleratorKey", object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerShortcut(String string, Object object) {
            HashSet<Action> hashSet = null;
            ShortcutsManager shortcutsManager = this;
            synchronized (shortcutsManager) {
                Object object2 = this.getShortcut(string);
                if (object2 != null && object2.equals(object) || object2 == null && object == null) {
                    return;
                }
                this.shorcuts.put(string, object);
                Set<Action> set = this.actions.get(string);
                if (set != null && !set.isEmpty()) {
                    hashSet = new HashSet<Action>();
                    hashSet.addAll(set);
                }
            }
            if (hashSet != null) {
                for (Action action : hashSet) {
                    if (action == null) continue;
                    action.putValue("AcceleratorKey", object);
                }
            }
        }

        public synchronized Object getShortcut(String string) {
            return this.shorcuts.get(string);
        }
    }

    private static class Wrapper {
        private Project project;

        Wrapper(Project project) {
            this.project = project;
        }

        public String toString() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }
    }
}

